/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityFile;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Util;
import java.util.Vector;

class LocalIdentityRepository
implements IdentityRepository {
    private static final String name = "Local Identity Repository";
    private Vector identities = new Vector();
    private JSch jsch;

    LocalIdentityRepository(JSch jsch) {
        this.jsch = jsch;
    }

    public String getName() {
        return name;
    }

    public int getStatus() {
        return 2;
    }

    public synchronized Vector getIdentities() {
        Vector v = new Vector();
        for (int i = 0; i < this.identities.size(); ++i) {
            v.addElement(this.identities.elementAt(i));
        }
        return v;
    }

    public synchronized void add(Identity identity2) {
        if (!this.identities.contains(identity2)) {
            this.identities.addElement(identity2);
        }
    }

    public synchronized boolean add(byte[] identity2) {
        try {
            IdentityFile _identity = IdentityFile.newInstance("from remote:", identity2, null, this.jsch);
            this.identities.addElement(_identity);
            return true;
        }
        catch (JSchException e2) {
            return false;
        }
    }

    synchronized void remove(Identity identity2) {
        this.identities.removeElement(identity2);
    }

    public synchronized boolean remove(byte[] blob) {
        if (blob == null) {
            return false;
        }
        for (int i = 0; i < this.identities.size(); ++i) {
            Identity _identity = (Identity)this.identities.elementAt(i);
            byte[] _blob = _identity.getPublicKeyBlob();
            if (_blob == null || !Util.array_equals(blob, _blob)) continue;
            this.identities.removeElement(_identity);
            _identity.clear();
            return true;
        }
        return false;
    }

    public synchronized void removeAll() {
        for (int i = 0; i < this.identities.size(); ++i) {
            Identity identity2 = (Identity)this.identities.elementAt(i);
            identity2.clear();
        }
        this.identities.removeAllElements();
    }
}

