/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.agentproxy.connector;

import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Buffer;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.USocketFactory;
import java.io.IOException;

public class SSHAgentConnector
implements Connector {
    private USocketFactory factory;

    public SSHAgentConnector(USocketFactory factory) throws AgentProxyException {
        this.factory = factory;
        USocketFactory.Socket sock = null;
        try {
            sock = this.open();
        }
        catch (IOException e2) {
            throw new AgentProxyException(e2.toString());
        }
        catch (Exception e3) {
            throw new AgentProxyException(e3.toString());
        }
        finally {
            try {
                if (sock != null) {
                    sock.close();
                }
            }
            catch (IOException e4) {
                throw new AgentProxyException(e4.toString());
            }
        }
    }

    public String getName() {
        return "ssh-agent";
    }

    public static boolean isConnectorAvailable() {
        return System.getenv("SSH_AUTH_SOCK") != null;
    }

    public boolean isAvailable() {
        return SSHAgentConnector.isConnectorAvailable();
    }

    private USocketFactory.Socket open() throws IOException {
        String ssh_auth_sock = System.getenv("SSH_AUTH_SOCK");
        if (ssh_auth_sock == null) {
            throw new IOException("SSH_AUTH_SOCK is not defined.");
        }
        return this.factory.open(ssh_auth_sock);
    }

    public void query(Buffer buffer) throws AgentProxyException {
        USocketFactory.Socket sock = null;
        try {
            sock = this.open();
            sock.write(buffer.buffer, 0, buffer.getLength());
            buffer.rewind();
            int i = sock.readFull(buffer.buffer, 0, 4);
            i = buffer.getInt();
            buffer.rewind();
            buffer.checkFreeSize(i);
            i = sock.readFull(buffer.buffer, 0, i);
        }
        catch (IOException e2) {
            throw new AgentProxyException(e2.toString());
        }
        finally {
            try {
                if (sock != null) {
                    sock.close();
                }
            }
            catch (IOException e3) {
                throw new AgentProxyException(e3.toString());
            }
        }
    }
}

