/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.FunctionMapper;
import com.sun.jna.IntegerType;
import com.sun.jna.Library;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

public final class Native {
    private static final String VERSION = "3.4.0";
    private static final String VERSION_NATIVE = "3.4.0";
    private static String nativeLibraryPath;
    private static Map typeMappers;
    private static Map alignments;
    private static Map options;
    private static Map libraries;
    private static final Callback.UncaughtExceptionHandler DEFAULT_HANDLER;
    private static Callback.UncaughtExceptionHandler callbackExceptionHandler;
    public static final int POINTER_SIZE;
    public static final int LONG_SIZE;
    public static final int WCHAR_SIZE;
    public static final int SIZE_T_SIZE;
    private static final int TYPE_VOIDP = 0;
    private static final int TYPE_LONG = 1;
    private static final int TYPE_WCHAR_T = 2;
    private static final int TYPE_SIZE_T = 3;
    private static final int THREAD_NOCHANGE = 0;
    private static final int THREAD_DETACH = -1;
    private static final int THREAD_LEAVE_ATTACHED = -2;
    private static final Object finalizer;
    private static final ThreadLocal lastError;
    private static Map registeredClasses;
    private static Map registeredLibraries;
    private static Object unloader;
    static final int CB_HAS_INITIALIZER = 1;
    private static final int CVT_UNSUPPORTED = -1;
    private static final int CVT_DEFAULT = 0;
    private static final int CVT_POINTER = 1;
    private static final int CVT_STRING = 2;
    private static final int CVT_STRUCTURE = 3;
    private static final int CVT_STRUCTURE_BYVAL = 4;
    private static final int CVT_BUFFER = 5;
    private static final int CVT_ARRAY_BYTE = 6;
    private static final int CVT_ARRAY_SHORT = 7;
    private static final int CVT_ARRAY_CHAR = 8;
    private static final int CVT_ARRAY_INT = 9;
    private static final int CVT_ARRAY_LONG = 10;
    private static final int CVT_ARRAY_FLOAT = 11;
    private static final int CVT_ARRAY_DOUBLE = 12;
    private static final int CVT_ARRAY_BOOLEAN = 13;
    private static final int CVT_BOOLEAN = 14;
    private static final int CVT_CALLBACK = 15;
    private static final int CVT_FLOAT = 16;
    private static final int CVT_NATIVE_MAPPED = 17;
    private static final int CVT_WSTRING = 18;
    private static final int CVT_INTEGER_TYPE = 19;
    private static final int CVT_POINTER_TYPE = 20;
    private static final int CVT_TYPE_MAPPER = 21;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$com$sun$jna$LastErrorException;
    static /* synthetic */ Class class$java$nio$Buffer;

    private static void dispose() {
        NativeLibrary.disposeAll();
        nativeLibraryPath = null;
    }

    private static boolean deleteNativeLibrary(String path2) {
        File flib = new File(path2);
        if (flib.delete()) {
            return true;
        }
        Native.markTemporaryFile(flib);
        return false;
    }

    private Native() {
    }

    private static native void initIDs();

    public static synchronized native void setProtected(boolean var0);

    public static synchronized native boolean isProtected();

    public static synchronized native void setPreserveLastError(boolean var0);

    public static synchronized native boolean getPreserveLastError();

    public static long getWindowID(Window w) throws HeadlessException {
        return AWT.getWindowID(w);
    }

    public static long getComponentID(Component c) throws HeadlessException {
        return AWT.getComponentID(c);
    }

    public static Pointer getWindowPointer(Window w) throws HeadlessException {
        return new Pointer(AWT.getWindowID(w));
    }

    public static Pointer getComponentPointer(Component c) throws HeadlessException {
        return new Pointer(AWT.getComponentID(c));
    }

    static native long getWindowHandle0(Component var0);

    public static Pointer getDirectBufferPointer(Buffer b) {
        long peer = Native._getDirectBufferPointer(b);
        return peer == 0L ? null : new Pointer(peer);
    }

    private static native long _getDirectBufferPointer(Buffer var0);

    public static String toString(byte[] buf) {
        return Native.toString(buf, System.getProperty("jna.encoding"));
    }

    public static String toString(byte[] buf, String encoding2) {
        int term;
        String s = null;
        if (encoding2 != null) {
            try {
                s = new String(buf, encoding2);
            }
            catch (UnsupportedEncodingException e2) {
                // empty catch block
            }
        }
        if (s == null) {
            s = new String(buf);
        }
        if ((term = s.indexOf(0)) != -1) {
            s = s.substring(0, term);
        }
        return s;
    }

    public static String toString(char[] buf) {
        String s = new String(buf);
        int term = s.indexOf(0);
        if (term != -1) {
            s = s.substring(0, term);
        }
        return s;
    }

    public static Object loadLibrary(Class interfaceClass) {
        return Native.loadLibrary(null, interfaceClass);
    }

    public static Object loadLibrary(Class interfaceClass, Map options) {
        return Native.loadLibrary(null, interfaceClass, options);
    }

    public static Object loadLibrary(String name2, Class interfaceClass) {
        return Native.loadLibrary(name2, interfaceClass, Collections.EMPTY_MAP);
    }

    public static Object loadLibrary(String name2, Class interfaceClass, Map options) {
        Library.Handler handler = new Library.Handler(name2, interfaceClass, options);
        ClassLoader loader = interfaceClass.getClassLoader();
        Library proxy2 = (Library)Proxy.newProxyInstance(loader, new Class[]{interfaceClass}, (InvocationHandler)handler);
        Native.cacheOptions(interfaceClass, options, proxy2);
        return proxy2;
    }

    private static void loadLibraryInstance(Class cls) {
        if (cls != null && !libraries.containsKey(cls)) {
            try {
                Field[] fields = cls.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if (field.getType() != cls || !Modifier.isStatic(field.getModifiers())) continue;
                    libraries.put(cls, new WeakReference<Object>(field.get(null)));
                    break;
                }
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Could not access instance of " + cls + " (" + e2 + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class findEnclosingLibraryClass(Class cls) {
        Class<?> declaring;
        Class fromDeclaring;
        if (cls == null) {
            return null;
        }
        Map map2 = libraries;
        synchronized (map2) {
            if (options.containsKey(cls)) {
                return cls;
            }
        }
        if (Library.class.isAssignableFrom(cls)) {
            return cls;
        }
        if (Callback.class.isAssignableFrom(cls)) {
            cls = CallbackReference.findCallbackClass(cls);
        }
        if ((fromDeclaring = Native.findEnclosingLibraryClass(declaring = cls.getDeclaringClass())) != null) {
            return fromDeclaring;
        }
        return Native.findEnclosingLibraryClass(cls.getSuperclass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getLibraryOptions(Class type2) {
        Map map2 = libraries;
        synchronized (map2) {
            Class interfaceClass = Native.findEnclosingLibraryClass(type2);
            if (interfaceClass != null) {
                Native.loadLibraryInstance(interfaceClass);
            } else {
                interfaceClass = type2;
            }
            if (!options.containsKey(interfaceClass)) {
                try {
                    Field field = interfaceClass.getField("OPTIONS");
                    field.setAccessible(true);
                    options.put(interfaceClass, field.get(null));
                }
                catch (NoSuchFieldException e2) {
                }
                catch (Exception e3) {
                    throw new IllegalArgumentException("OPTIONS must be a public field of type java.util.Map (" + e3 + "): " + interfaceClass);
                }
            }
            return (Map)options.get(interfaceClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeMapper getTypeMapper(Class cls) {
        Map map2 = libraries;
        synchronized (map2) {
            Class interfaceClass = Native.findEnclosingLibraryClass(cls);
            if (interfaceClass != null) {
                Native.loadLibraryInstance(interfaceClass);
            } else {
                interfaceClass = cls;
            }
            if (!typeMappers.containsKey(interfaceClass)) {
                try {
                    Field field = interfaceClass.getField("TYPE_MAPPER");
                    field.setAccessible(true);
                    typeMappers.put(interfaceClass, field.get(null));
                }
                catch (NoSuchFieldException e2) {
                    Map options = Native.getLibraryOptions(cls);
                    if (options != null && options.containsKey("type-mapper")) {
                        typeMappers.put(interfaceClass, options.get("type-mapper"));
                    }
                }
                catch (Exception e3) {
                    throw new IllegalArgumentException("TYPE_MAPPER must be a public field of type " + TypeMapper.class.getName() + " (" + e3 + "): " + interfaceClass);
                }
            }
            return (TypeMapper)typeMappers.get(interfaceClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStructureAlignment(Class cls) {
        Map map2 = libraries;
        synchronized (map2) {
            Integer value;
            Class interfaceClass = Native.findEnclosingLibraryClass(cls);
            if (interfaceClass != null) {
                Native.loadLibraryInstance(interfaceClass);
            } else {
                interfaceClass = cls;
            }
            if (!alignments.containsKey(interfaceClass)) {
                try {
                    Field field = interfaceClass.getField("STRUCTURE_ALIGNMENT");
                    field.setAccessible(true);
                    alignments.put(interfaceClass, field.get(null));
                }
                catch (NoSuchFieldException e2) {
                    Map options = Native.getLibraryOptions(interfaceClass);
                    if (options != null && options.containsKey("structure-alignment")) {
                        alignments.put(interfaceClass, options.get("structure-alignment"));
                    }
                }
                catch (Exception e3) {
                    throw new IllegalArgumentException("STRUCTURE_ALIGNMENT must be a public field of type int (" + e3 + "): " + interfaceClass);
                }
            }
            int n = (value = (Integer)alignments.get(interfaceClass)) != null ? value : 0;
            return n;
        }
    }

    static byte[] getBytes(String s) {
        try {
            return Native.getBytes(s, System.getProperty("jna.encoding"));
        }
        catch (UnsupportedEncodingException e2) {
            return s.getBytes();
        }
    }

    static byte[] getBytes(String s, String encoding2) throws UnsupportedEncodingException {
        if (encoding2 != null) {
            return s.getBytes(encoding2);
        }
        return s.getBytes();
    }

    public static byte[] toByteArray(String s) {
        byte[] bytes2 = Native.getBytes(s);
        byte[] buf = new byte[bytes2.length + 1];
        System.arraycopy(bytes2, 0, buf, 0, bytes2.length);
        return buf;
    }

    public static byte[] toByteArray(String s, String encoding2) throws UnsupportedEncodingException {
        byte[] bytes2 = Native.getBytes(s, encoding2);
        byte[] buf = new byte[bytes2.length + 1];
        System.arraycopy(bytes2, 0, buf, 0, bytes2.length);
        return buf;
    }

    public static char[] toCharArray(String s) {
        char[] chars2 = s.toCharArray();
        char[] buf = new char[chars2.length + 1];
        System.arraycopy(chars2, 0, buf, 0, chars2.length);
        return buf;
    }

    static String getNativeLibraryResourcePath(int osType, String arch, String name2) {
        String osPrefix;
        if ("powerpc".equals(arch = arch.toLowerCase())) {
            arch = "ppc";
        } else if ("powerpc64".equals(arch)) {
            arch = "ppc64";
        }
        switch (osType) {
            case 2: {
                if ("i386".equals(arch)) {
                    arch = "x86";
                }
                osPrefix = "win32-" + arch;
                break;
            }
            case 6: {
                osPrefix = "w32ce-" + arch;
                break;
            }
            case 0: {
                osPrefix = "darwin";
                break;
            }
            case 1: {
                if ("x86".equals(arch)) {
                    arch = "i386";
                } else if ("x86_64".equals(arch)) {
                    arch = "amd64";
                }
                osPrefix = "linux-" + arch;
                break;
            }
            case 3: {
                osPrefix = "sunos-" + arch;
                break;
            }
            default: {
                int space;
                osPrefix = name2.toLowerCase();
                if ("x86".equals(arch)) {
                    arch = "i386";
                }
                if ("x86_64".equals(arch)) {
                    arch = "amd64";
                }
                if ((space = osPrefix.indexOf(" ")) != -1) {
                    osPrefix = osPrefix.substring(0, space);
                }
                osPrefix = osPrefix + "-" + arch;
            }
        }
        return "/com/sun/jna/" + osPrefix;
    }

    private static void loadNativeLibrary() {
        block13: {
            Native.removeTemporaryFiles();
            String libName = System.getProperty("jna.boot.library.name", "jnidispatch");
            String bootPath = System.getProperty("jna.boot.library.path");
            if (bootPath != null) {
                StringTokenizer dirs = new StringTokenizer(bootPath, File.pathSeparator);
                while (dirs.hasMoreTokens()) {
                    String ext;
                    String orig;
                    String dir2 = dirs.nextToken();
                    File file2 = new File(new File(dir2), System.mapLibraryName(libName));
                    String path2 = file2.getAbsolutePath();
                    if (file2.exists()) {
                        try {
                            System.load(path2);
                            nativeLibraryPath = path2;
                            return;
                        }
                        catch (UnsatisfiedLinkError ex) {
                            // empty catch block
                        }
                    }
                    if (!Platform.isMac()) continue;
                    if (path2.endsWith("dylib")) {
                        orig = "dylib";
                        ext = "jnilib";
                    } else {
                        orig = "jnilib";
                        ext = "dylib";
                    }
                    if (!new File(path2 = path2.substring(0, path2.lastIndexOf(orig)) + ext).exists()) continue;
                    try {
                        System.load(path2);
                        nativeLibraryPath = path2;
                        return;
                    }
                    catch (UnsatisfiedLinkError ex) {
                        System.err.println("File found at " + path2 + " but not loadable: " + ex.getMessage());
                    }
                }
            }
            try {
                if (!Boolean.getBoolean("jna.nosys")) {
                    System.loadLibrary(libName);
                    return;
                }
            }
            catch (UnsatisfiedLinkError e2) {
                if (!Boolean.getBoolean("jna.nounpack")) break block13;
                throw e2;
            }
        }
        if (!Boolean.getBoolean("jna.nounpack")) {
            Native.loadNativeLibraryFromJar();
            return;
        }
        throw new UnsatisfiedLinkError("Native jnidispatch library not found");
    }

    private static void loadNativeLibraryFromJar() {
        String libname = System.mapLibraryName("jnidispatch");
        String arch = System.getProperty("os.arch");
        String name2 = System.getProperty("os.name");
        String resourceName = Native.getNativeLibraryResourcePath(Platform.getOSType(), arch, name2) + "/" + libname;
        URL url = Native.class.getResource(resourceName);
        boolean unpacked = false;
        if (url == null && Platform.isMac() && resourceName.endsWith(".dylib")) {
            resourceName = resourceName.substring(0, resourceName.lastIndexOf(".dylib")) + ".jnilib";
            url = Native.class.getResource(resourceName);
        }
        if (url == null) {
            throw new UnsatisfiedLinkError("jnidispatch (" + resourceName + ") not found in resource path");
        }
        File lib = null;
        if (url.getProtocol().toLowerCase().equals("file")) {
            try {
                lib = new File(new URI(url.toString()));
            }
            catch (URISyntaxException e2) {
                lib = new File(url.getPath());
            }
            if (!lib.exists()) {
                throw new Error("File URL " + url + " could not be properly decoded");
            }
        } else {
            InputStream is2 = Native.class.getResourceAsStream(resourceName);
            if (is2 == null) {
                throw new Error("Can't obtain jnidispatch InputStream");
            }
            FileOutputStream fos = null;
            try {
                int count2;
                File dir2 = Native.getTempDir();
                lib = File.createTempFile("jna", Platform.isWindows() ? ".dll" : null, dir2);
                lib.deleteOnExit();
                fos = new FileOutputStream(lib);
                byte[] buf = new byte[1024];
                while ((count2 = is2.read(buf, 0, buf.length)) > 0) {
                    fos.write(buf, 0, count2);
                }
                unpacked = true;
            }
            catch (IOException e3) {
                throw new Error("Failed to create temporary file for jnidispatch library: " + e3);
            }
            finally {
                try {
                    is2.close();
                }
                catch (IOException e4) {}
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e5) {}
                }
            }
        }
        System.load(lib.getAbsolutePath());
        nativeLibraryPath = lib.getAbsolutePath();
        if (unpacked) {
            Native.deleteNativeLibrary(lib.getAbsolutePath());
        }
    }

    private static native int sizeof(int var0);

    private static native String getNativeVersion();

    private static native String getAPIChecksum();

    public static int getLastError() {
        return (Integer)lastError.get();
    }

    public static native void setLastError(int var0);

    static void updateLastError(int e2) {
        lastError.set(new Integer(e2));
    }

    public static Library synchronizedLibrary(final Library library) {
        Class<?> cls = library.getClass();
        if (!Proxy.isProxyClass(cls)) {
            throw new IllegalArgumentException("Library must be a proxy class");
        }
        InvocationHandler ih = Proxy.getInvocationHandler(library);
        if (!(ih instanceof Library.Handler)) {
            throw new IllegalArgumentException("Unrecognized proxy handler: " + ih);
        }
        final Library.Handler handler = (Library.Handler)ih;
        InvocationHandler newHandler = new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(Object proxy2, Method method, Object[] args) throws Throwable {
                NativeLibrary nativeLibrary = handler.getNativeLibrary();
                synchronized (nativeLibrary) {
                    return handler.invoke(library, method, args);
                }
            }
        };
        return (Library)Proxy.newProxyInstance(cls.getClassLoader(), cls.getInterfaces(), newHandler);
    }

    public static String getWebStartLibraryPath(String libName) {
        if (System.getProperty("javawebstart.version") == null) {
            return null;
        }
        try {
            ClassLoader cl = Native.class.getClassLoader();
            Method m = (Method)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Method m = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Native.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredMethod("findLibrary", class$java$lang$String == null ? (class$java$lang$String = Native.class$("java.lang.String")) : class$java$lang$String);
                        m.setAccessible(true);
                        return m;
                    }
                    catch (Exception e2) {
                        return null;
                    }
                }
            });
            String libpath = (String)m.invoke((Object)cl, libName);
            if (libpath != null) {
                return new File(libpath).getParent();
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    static void markTemporaryFile(File file2) {
        try {
            File marker = new File(file2.getParentFile(), file2.getName() + ".x");
            marker.createNewFile();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    static File getTempDir() {
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        File jnatmp = new File(tmp, "jna");
        jnatmp.mkdirs();
        return jnatmp.exists() ? jnatmp : tmp;
    }

    static void removeTemporaryFiles() {
        File dir2 = Native.getTempDir();
        FilenameFilter filter2 = new FilenameFilter(){

            public boolean accept(File dir2, String name2) {
                return name2.endsWith(".x") && name2.indexOf("jna") != -1;
            }
        };
        File[] files = dir2.listFiles(filter2);
        for (int i = 0; files != null && i < files.length; ++i) {
            File marker = files[i];
            String name2 = marker.getName();
            name2 = name2.substring(0, name2.length() - 2);
            File target = new File(marker.getParentFile(), name2);
            if (target.exists() && !target.delete()) continue;
            marker.delete();
        }
    }

    public static int getNativeSize(Class type2, Object value) {
        if (type2.isArray()) {
            int len = Array.getLength(value);
            if (len > 0) {
                Object o = Array.get(value, 0);
                return len * Native.getNativeSize(type2.getComponentType(), o);
            }
            throw new IllegalArgumentException("Arrays of length zero not allowed: " + type2);
        }
        if (Structure.class.isAssignableFrom(type2) && !Structure.ByReference.class.isAssignableFrom(type2)) {
            if (value == null) {
                value = Structure.newInstance(type2);
            }
            return ((Structure)value).size();
        }
        try {
            return Native.getNativeSize(type2);
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException("The type \"" + type2.getName() + "\" is not supported: " + e2.getMessage());
        }
    }

    public static int getNativeSize(Class cls) {
        if (NativeMapped.class.isAssignableFrom(cls)) {
            cls = NativeMappedConverter.getInstance(cls).nativeType();
        }
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return 4;
        }
        if (cls == Byte.TYPE || cls == Byte.class) {
            return 1;
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return 2;
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return WCHAR_SIZE;
        }
        if (cls == Integer.TYPE || cls == Integer.class) {
            return 4;
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return 8;
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return 4;
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return 8;
        }
        if (Structure.class.isAssignableFrom(cls)) {
            if (Structure.ByValue.class.isAssignableFrom(cls)) {
                return Structure.newInstance(cls).size();
            }
            return POINTER_SIZE;
        }
        if (Pointer.class.isAssignableFrom(cls) || Platform.HAS_BUFFERS && Buffers.isBuffer(cls) || Callback.class.isAssignableFrom(cls) || String.class == cls || WString.class == cls) {
            return POINTER_SIZE;
        }
        throw new IllegalArgumentException("Native size for type \"" + cls.getName() + "\" is unknown");
    }

    public static boolean isSupportedNativeType(Class cls) {
        if (Structure.class.isAssignableFrom(cls)) {
            return true;
        }
        try {
            return Native.getNativeSize(cls) != 0;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static void setCallbackExceptionHandler(Callback.UncaughtExceptionHandler eh) {
        callbackExceptionHandler = eh == null ? DEFAULT_HANDLER : eh;
    }

    public static Callback.UncaughtExceptionHandler getCallbackExceptionHandler() {
        return callbackExceptionHandler;
    }

    public static void register(String libName) {
        Native.register(Native.getNativeClass(Native.getCallingClass()), NativeLibrary.getInstance(libName));
    }

    public static void register(NativeLibrary lib) {
        Native.register(Native.getNativeClass(Native.getCallingClass()), lib);
    }

    static Class getNativeClass(Class cls) {
        Method[] methods2 = cls.getDeclaredMethods();
        for (int i = 0; i < methods2.length; ++i) {
            if ((methods2[i].getModifiers() & 0x100) == 0) continue;
            return cls;
        }
        int idx = cls.getName().lastIndexOf("$");
        if (idx != -1) {
            String name2 = cls.getName().substring(0, idx);
            try {
                return Native.getNativeClass(Class.forName(name2, true, cls.getClassLoader()));
            }
            catch (ClassNotFoundException e2) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Can't determine class with native methods from the current context (" + cls + ")");
    }

    static Class getCallingClass() {
        Class[] context = new SecurityManager(){

            public Class[] getClassContext() {
                return super.getClassContext();
            }
        }.getClassContext();
        if (context.length < 4) {
            throw new IllegalStateException("This method must be called from the static initializer of a class");
        }
        return context[3];
    }

    public static void setCallbackThreadInitializer(Callback cb, CallbackThreadInitializer initializer) {
        CallbackReference.setCallbackThreadInitializer(cb, initializer);
    }

    public static void unregister() {
        Native.unregister(Native.getNativeClass(Native.getCallingClass()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(Class cls) {
        Map map2 = registeredClasses;
        synchronized (map2) {
            if (registeredClasses.containsKey(cls)) {
                Native.unregister(cls, (long[])registeredClasses.get(cls));
                registeredClasses.remove(cls);
                registeredLibraries.remove(cls);
            }
        }
    }

    private static native void unregister(Class var0, long[] var1);

    private static String getSignature(Class cls) {
        if (cls.isArray()) {
            return "[" + Native.getSignature(cls.getComponentType());
        }
        if (cls.isPrimitive()) {
            if (cls == Void.TYPE) {
                return "V";
            }
            if (cls == Boolean.TYPE) {
                return "Z";
            }
            if (cls == Byte.TYPE) {
                return "B";
            }
            if (cls == Short.TYPE) {
                return "S";
            }
            if (cls == Character.TYPE) {
                return "C";
            }
            if (cls == Integer.TYPE) {
                return "I";
            }
            if (cls == Long.TYPE) {
                return "J";
            }
            if (cls == Float.TYPE) {
                return "F";
            }
            if (cls == Double.TYPE) {
                return "D";
            }
        }
        return "L" + Native.replace(".", "/", cls.getName()) + ";";
    }

    static String replace(String s1, String s2, String str2) {
        StringBuffer buf = new StringBuffer();
        while (true) {
            int idx;
            if ((idx = str2.indexOf(s1)) == -1) break;
            buf.append(str2.substring(0, idx));
            buf.append(s2);
            str2 = str2.substring(idx + s1.length());
        }
        buf.append(str2);
        return buf.toString();
    }

    private static int getConversion(Class type2, TypeMapper mapper) {
        if (type2 == Boolean.class) {
            type2 = Boolean.TYPE;
        } else if (type2 == Byte.class) {
            type2 = Byte.TYPE;
        } else if (type2 == Short.class) {
            type2 = Short.TYPE;
        } else if (type2 == Character.class) {
            type2 = Character.TYPE;
        } else if (type2 == Integer.class) {
            type2 = Integer.TYPE;
        } else if (type2 == Long.class) {
            type2 = Long.TYPE;
        } else if (type2 == Float.class) {
            type2 = Float.TYPE;
        } else if (type2 == Double.class) {
            type2 = Double.TYPE;
        } else if (type2 == Void.class) {
            type2 = Void.TYPE;
        }
        if (mapper != null && (mapper.getFromNativeConverter(type2) != null || mapper.getToNativeConverter(type2) != null)) {
            return 21;
        }
        if (Pointer.class.isAssignableFrom(type2)) {
            return 1;
        }
        if (String.class == type2) {
            return 2;
        }
        if (WString.class.isAssignableFrom(type2)) {
            return 18;
        }
        if (Platform.HAS_BUFFERS && Buffers.isBuffer(type2)) {
            return 5;
        }
        if (Structure.class.isAssignableFrom(type2)) {
            if (Structure.ByValue.class.isAssignableFrom(type2)) {
                return 4;
            }
            return 3;
        }
        if (type2.isArray()) {
            switch (type2.getName().charAt(1)) {
                case 'Z': {
                    return 13;
                }
                case 'B': {
                    return 6;
                }
                case 'S': {
                    return 7;
                }
                case 'C': {
                    return 8;
                }
                case 'I': {
                    return 9;
                }
                case 'J': {
                    return 10;
                }
                case 'F': {
                    return 11;
                }
                case 'D': {
                    return 12;
                }
            }
        }
        if (type2.isPrimitive()) {
            return type2 == Boolean.TYPE ? 14 : 0;
        }
        if (Callback.class.isAssignableFrom(type2)) {
            return 15;
        }
        if (IntegerType.class.isAssignableFrom(type2)) {
            return 19;
        }
        if (PointerType.class.isAssignableFrom(type2)) {
            return 20;
        }
        if (NativeMapped.class.isAssignableFrom(type2)) {
            return 17;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Class cls, NativeLibrary lib) {
        Method[] methods2 = cls.getDeclaredMethods();
        ArrayList<Method> mlist = new ArrayList<Method>();
        TypeMapper mapper = (TypeMapper)lib.getOptions().get("type-mapper");
        for (int i = 0; i < methods2.length; ++i) {
            if ((methods2[i].getModifiers() & 0x100) == 0) continue;
            mlist.add(methods2[i]);
        }
        long[] handles = new long[mlist.size()];
        for (int i = 0; i < handles.length; ++i) {
            long rtype;
            long closure_rtype;
            Method method = (Method)mlist.get(i);
            String sig = "(";
            Class<?> rclass = method.getReturnType();
            Class<?>[] ptypes = method.getParameterTypes();
            long[] atypes = new long[ptypes.length];
            long[] closure_atypes = new long[ptypes.length];
            int[] cvt = new int[ptypes.length];
            ToNativeConverter[] toNative = new ToNativeConverter[ptypes.length];
            FromNativeConverter fromNative = null;
            int rcvt = Native.getConversion(rclass, mapper);
            boolean throwLastError = false;
            switch (rcvt) {
                case -1: {
                    throw new IllegalArgumentException(rclass + " is not a supported return type (in method " + method.getName() + " in " + cls + ")");
                }
                case 21: {
                    fromNative = mapper.getFromNativeConverter(rclass);
                    closure_rtype = Structure.FFIType.get(rclass).peer;
                    rtype = Structure.FFIType.get((Object)fromNative.nativeType()).peer;
                    break;
                }
                case 17: 
                case 19: 
                case 20: {
                    closure_rtype = Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                    rtype = Structure.FFIType.get((Object)NativeMappedConverter.getInstance(rclass).nativeType()).peer;
                    break;
                }
                case 3: {
                    closure_rtype = rtype = Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                    break;
                }
                case 4: {
                    closure_rtype = Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                    rtype = Structure.FFIType.get(rclass).peer;
                    break;
                }
                default: {
                    closure_rtype = rtype = Structure.FFIType.get(rclass).peer;
                }
            }
            block19: for (int t = 0; t < ptypes.length; ++t) {
                Class type2 = ptypes[t];
                sig = sig + Native.getSignature(type2);
                cvt[t] = Native.getConversion(type2, mapper);
                if (cvt[t] == -1) {
                    throw new IllegalArgumentException(type2 + " is not a supported argument type (in method " + method.getName() + " in " + cls + ")");
                }
                if (cvt[t] == 17 || cvt[t] == 19) {
                    type2 = NativeMappedConverter.getInstance(type2).nativeType();
                } else if (cvt[t] == 21) {
                    toNative[t] = mapper.getToNativeConverter(type2);
                }
                switch (cvt[t]) {
                    case 4: 
                    case 17: 
                    case 19: 
                    case 20: {
                        atypes[t] = Structure.FFIType.get((Object)type2).peer;
                        closure_atypes[t] = Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                        continue block19;
                    }
                    case 21: {
                        closure_atypes[t] = type2.isPrimitive() ? Structure.FFIType.get((Object)type2).peer : Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                        atypes[t] = Structure.FFIType.get((Object)toNative[t].nativeType()).peer;
                        continue block19;
                    }
                    case 0: {
                        closure_atypes[t] = atypes[t] = Structure.FFIType.get((Object)type2).peer;
                        continue block19;
                    }
                    default: {
                        closure_atypes[t] = atypes[t] = Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                    }
                }
            }
            sig = sig + ")";
            sig = sig + Native.getSignature(rclass);
            Class<?>[] etypes = method.getExceptionTypes();
            for (int e2 = 0; e2 < etypes.length; ++e2) {
                if (!(class$com$sun$jna$LastErrorException == null ? Native.class$("com.sun.jna.LastErrorException") : class$com$sun$jna$LastErrorException).isAssignableFrom(etypes[e2])) continue;
                throwLastError = true;
                break;
            }
            String name2 = method.getName();
            FunctionMapper fmapper = (FunctionMapper)lib.getOptions().get("function-mapper");
            if (fmapper != null) {
                name2 = fmapper.getFunctionName(lib, method);
            }
            Function f = lib.getFunction(name2, method);
            try {
                handles[i] = Native.registerMethod(cls, method.getName(), sig, cvt, closure_atypes, atypes, rcvt, closure_rtype, rtype, rclass, f.peer, f.getCallingConvention(), throwLastError, toNative, fromNative);
                continue;
            }
            catch (NoSuchMethodError e3) {
                throw new UnsatisfiedLinkError("No method " + method.getName() + " with signature " + sig + " in " + cls);
            }
        }
        Map map2 = registeredClasses;
        synchronized (map2) {
            registeredClasses.put(cls, handles);
            registeredLibraries.put(cls, lib);
        }
        Native.cacheOptions(cls, lib.getOptions(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheOptions(Class cls, Map libOptions, Object proxy2) {
        Map map2 = libraries;
        synchronized (map2) {
            if (!libOptions.isEmpty()) {
                options.put(cls, libOptions);
            }
            if (libOptions.containsKey("type-mapper")) {
                typeMappers.put(cls, libOptions.get("type-mapper"));
            }
            if (libOptions.containsKey("structure-alignment")) {
                alignments.put(cls, libOptions.get("structure-alignment"));
            }
            if (proxy2 != null) {
                libraries.put(cls, new WeakReference<Object>(proxy2));
            }
            if (!cls.isInterface() && Library.class.isAssignableFrom(cls)) {
                Class<?>[] ifaces = cls.getInterfaces();
                for (int i = 0; i < ifaces.length; ++i) {
                    if (!(class$com$sun$jna$Library == null ? Native.class$("com.sun.jna.Library") : class$com$sun$jna$Library).isAssignableFrom(ifaces[i])) continue;
                    Native.cacheOptions(ifaces[i], libOptions, proxy2);
                    break;
                }
            }
        }
    }

    private static native long registerMethod(Class var0, String var1, String var2, int[] var3, long[] var4, long[] var5, int var6, long var7, long var9, Class var11, long var12, int var14, boolean var15, ToNativeConverter[] var16, FromNativeConverter var17);

    private static NativeMapped fromNative(Class cls, Object value) {
        return (NativeMapped)NativeMappedConverter.getInstance(cls).fromNative(value, new FromNativeContext(cls));
    }

    private static Class nativeType(Class cls) {
        return NativeMappedConverter.getInstance(cls).nativeType();
    }

    private static Object toNative(ToNativeConverter cvt, Object o) {
        return cvt.toNative(o, new ToNativeContext());
    }

    private static Object fromNative(FromNativeConverter cvt, Object o, Class cls) {
        return cvt.fromNative(o, new FromNativeContext(cls));
    }

    public static native long ffi_prep_cif(int var0, int var1, long var2, long var4);

    public static native void ffi_call(long var0, long var2, long var4, long var6);

    public static native long ffi_prep_closure(long var0, ffi_callback var2);

    public static native void ffi_free_closure(long var0);

    static native int initialize_ffi_type(long var0);

    public static void main(String[] args) {
        String version;
        String title;
        String DEFAULT_TITLE = "Java Native Access (JNA)";
        String DEFAULT_VERSION = "3.4.0";
        String DEFAULT_BUILD = "3.4.0 (package information missing)";
        Package pkg = Native.class.getPackage();
        String string2 = title = pkg != null ? pkg.getSpecificationTitle() : "Java Native Access (JNA)";
        if (title == null) {
            title = "Java Native Access (JNA)";
        }
        String string3 = version = pkg != null ? pkg.getSpecificationVersion() : "3.4.0";
        if (version == null) {
            version = "3.4.0";
        }
        title = title + " API Version " + version;
        System.out.println(title);
        String string4 = version = pkg != null ? pkg.getImplementationVersion() : "3.4.0 (package information missing)";
        if (version == null) {
            version = "3.4.0 (package information missing)";
        }
        System.out.println("Version: " + version);
        System.out.println(" Native: " + Native.getNativeVersion() + " (" + Native.getAPIChecksum() + ")");
        System.exit(0);
    }

    static synchronized native void freeNativeCallback(long var0);

    static synchronized native long createNativeCallback(Callback var0, Method var1, Class[] var2, Class var3, int var4, boolean var5);

    static native int invokeInt(long var0, int var2, Object[] var3);

    static native long invokeLong(long var0, int var2, Object[] var3);

    static native void invokeVoid(long var0, int var2, Object[] var3);

    static native float invokeFloat(long var0, int var2, Object[] var3);

    static native double invokeDouble(long var0, int var2, Object[] var3);

    static native long invokePointer(long var0, int var2, Object[] var3);

    private static native void invokeStructure(long var0, int var2, Object[] var3, long var4, long var6);

    static Structure invokeStructure(long fp, int callFlags, Object[] args, Structure s) {
        Native.invokeStructure(fp, callFlags, args, s.getPointer().peer, s.getTypeInfo().peer);
        return s;
    }

    static native Object invokeObject(long var0, int var2, Object[] var3);

    static native long open(String var0);

    static native void close(long var0);

    static native long findSymbol(long var0, String var2);

    static native long indexOf(long var0, byte var2);

    static native void read(long var0, byte[] var2, int var3, int var4);

    static native void read(long var0, short[] var2, int var3, int var4);

    static native void read(long var0, char[] var2, int var3, int var4);

    static native void read(long var0, int[] var2, int var3, int var4);

    static native void read(long var0, long[] var2, int var3, int var4);

    static native void read(long var0, float[] var2, int var3, int var4);

    static native void read(long var0, double[] var2, int var3, int var4);

    static native void write(long var0, byte[] var2, int var3, int var4);

    static native void write(long var0, short[] var2, int var3, int var4);

    static native void write(long var0, char[] var2, int var3, int var4);

    static native void write(long var0, int[] var2, int var3, int var4);

    static native void write(long var0, long[] var2, int var3, int var4);

    static native void write(long var0, float[] var2, int var3, int var4);

    static native void write(long var0, double[] var2, int var3, int var4);

    static native byte getByte(long var0);

    static native char getChar(long var0);

    static native short getShort(long var0);

    static native int getInt(long var0);

    static native long getLong(long var0);

    static native float getFloat(long var0);

    static native double getDouble(long var0);

    static Pointer getPointer(long addr) {
        long peer = Native._getPointer(addr);
        return peer == 0L ? null : new Pointer(peer);
    }

    private static native long _getPointer(long var0);

    static native String getString(long var0, boolean var2);

    static native void setMemory(long var0, long var2, byte var4);

    static native void setByte(long var0, byte var2);

    static native void setShort(long var0, short var2);

    static native void setChar(long var0, char var2);

    static native void setInt(long var0, int var2);

    static native void setLong(long var0, long var2);

    static native void setFloat(long var0, float var2);

    static native void setDouble(long var0, double var2);

    static native void setPointer(long var0, long var2);

    static native void setString(long var0, String var2, boolean var3);

    public static native long malloc(long var0);

    public static native void free(long var0);

    public static native ByteBuffer getDirectByteBuffer(long var0, long var2);

    public static void detach(boolean detach) {
        Native.setLastError(detach ? -1 : -2);
    }

    static {
        String version;
        nativeLibraryPath = null;
        typeMappers = new WeakHashMap();
        alignments = new WeakHashMap();
        options = new WeakHashMap();
        libraries = new WeakHashMap();
        callbackExceptionHandler = DEFAULT_HANDLER = new Callback.UncaughtExceptionHandler(){

            public void uncaughtException(Callback c, Throwable e2) {
                System.err.println("JNA: Callback " + c + " threw the following exception:");
                e2.printStackTrace();
            }
        };
        Native.loadNativeLibrary();
        POINTER_SIZE = Native.sizeof(0);
        LONG_SIZE = Native.sizeof(1);
        WCHAR_SIZE = Native.sizeof(2);
        SIZE_T_SIZE = Native.sizeof(3);
        Native.initIDs();
        if (Boolean.getBoolean("jna.protected")) {
            Native.setProtected(true);
        }
        if (!"3.4.0".equals(version = Native.getNativeVersion())) {
            String LS = System.getProperty("line.separator");
            throw new Error(LS + LS + "There is an incompatible JNA native library installed on this system." + LS + "To resolve this issue you may do one of the following:" + LS + " - remove or uninstall the offending library" + LS + " - set the system property jna.nosys=true" + LS + " - set jna.boot.library.path to include the path to the version of the " + LS + "   jnidispatch library included with the JNA jar file you are using" + LS);
        }
        Native.setPreserveLastError("true".equalsIgnoreCase(System.getProperty("jna.preserve_last_error", "true")));
        finalizer = new Object(){

            protected void finalize() {
                Native.dispose();
            }
        };
        lastError = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new Integer(0);
            }
        };
        registeredClasses = new HashMap();
        registeredLibraries = new HashMap();
        unloader = new Object(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() {
                Map map2 = registeredClasses;
                synchronized (map2) {
                    Iterator i = registeredClasses.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry e2 = i.next();
                        Native.unregister((Class)e2.getKey(), (long[])e2.getValue());
                        i.remove();
                    }
                }
            }
        };
    }

    private static class AWT {
        private AWT() {
        }

        static long getWindowID(Window w) throws HeadlessException {
            return AWT.getComponentID(w);
        }

        static long getComponentID(Object o) throws HeadlessException {
            if (GraphicsEnvironment.isHeadless()) {
                throw new HeadlessException("No native windows when headless");
            }
            Component c = (Component)o;
            if (c.isLightweight()) {
                throw new IllegalArgumentException("Component must be heavyweight");
            }
            if (!c.isDisplayable()) {
                throw new IllegalStateException("Component must be displayable");
            }
            if (Platform.isX11() && System.getProperty("java.version").startsWith("1.4") && !c.isVisible()) {
                throw new IllegalStateException("Component must be visible");
            }
            return Native.getWindowHandle0(c);
        }
    }

    private static class Buffers {
        private Buffers() {
        }

        static boolean isBuffer(Class cls) {
            return (class$java$nio$Buffer == null ? (class$java$nio$Buffer = Native.class$("java.nio.Buffer")) : class$java$nio$Buffer).isAssignableFrom(cls);
        }
    }

    public static interface ffi_callback {
        public void invoke(long var1, long var3, long var5);
    }
}

