/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class NativeLibrary {
    private long handle;
    private final String libraryName;
    private final String libraryPath;
    private final Map functions = new HashMap();
    final int callFlags;
    final Map options;
    private static final Map libraries = new HashMap();
    private static final Map searchPaths = Collections.synchronizedMap(new HashMap());
    private static final List librarySearchPath = new LinkedList();
    static /* synthetic */ Class class$com$sun$jna$LastErrorException;

    private static String functionKey(String name2, int flags) {
        return name2 + "|" + flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeLibrary(String libraryName, String libraryPath, long handle, Map options) {
        int callingConvention;
        this.libraryName = this.getLibraryName(libraryName);
        this.libraryPath = libraryPath;
        this.handle = handle;
        Object option = options.get("calling-convention");
        this.callFlags = callingConvention = option instanceof Integer ? (Integer)option : 0;
        this.options = options;
        if (Platform.isWindows() && "kernel32".equals(this.libraryName.toLowerCase())) {
            Map map2 = this.functions;
            synchronized (map2) {
                Function f = new Function(this, "GetLastError", 1){

                    Object invoke(Object[] args, Class returnType, boolean b) {
                        return new Integer(Native.getLastError());
                    }
                };
                this.functions.put(NativeLibrary.functionKey("GetLastError", this.callFlags), f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NativeLibrary loadLibrary(String libraryName, Map options) {
        long handle;
        String libraryPath;
        block23: {
            List customPaths;
            LinkedList<String> searchPath = new LinkedList<String>();
            String webstartPath = Native.getWebStartLibraryPath(libraryName);
            if (webstartPath != null) {
                searchPath.add(webstartPath);
            }
            if ((customPaths = (List)searchPaths.get(libraryName)) != null) {
                List list = customPaths;
                synchronized (list) {
                    searchPath.addAll(0, customPaths);
                }
            }
            searchPath.addAll(NativeLibrary.initPaths("jna.library.path"));
            libraryPath = NativeLibrary.findLibraryPath(libraryName, searchPath);
            handle = 0L;
            try {
                handle = Native.open(libraryPath);
            }
            catch (UnsatisfiedLinkError e2) {
                searchPath.addAll(librarySearchPath);
            }
            try {
                if (handle == 0L && (handle = Native.open(libraryPath = NativeLibrary.findLibraryPath(libraryName, searchPath))) == 0L) {
                    throw new UnsatisfiedLinkError("Failed to load library '" + libraryName + "'");
                }
            }
            catch (UnsatisfiedLinkError e3) {
                if (Platform.isLinux()) {
                    libraryPath = NativeLibrary.matchLibrary(libraryName, searchPath);
                    if (libraryPath != null) {
                        try {
                            handle = Native.open(libraryPath);
                        }
                        catch (UnsatisfiedLinkError e2) {
                            e3 = e2;
                        }
                    }
                } else if (Platform.isMac() && !libraryName.endsWith(".dylib")) {
                    libraryPath = "/System/Library/Frameworks/" + libraryName + ".framework/" + libraryName;
                    if (new File(libraryPath).exists()) {
                        try {
                            handle = Native.open(libraryPath);
                        }
                        catch (UnsatisfiedLinkError e2) {
                            e3 = e2;
                        }
                    }
                } else if (Platform.isWindows()) {
                    libraryPath = NativeLibrary.findLibraryPath("lib" + libraryName, searchPath);
                    try {
                        handle = Native.open(libraryPath);
                    }
                    catch (UnsatisfiedLinkError e2) {
                        e3 = e2;
                    }
                }
                if (handle != 0L) break block23;
                throw new UnsatisfiedLinkError("Unable to load library '" + libraryName + "': " + e3.getMessage());
            }
        }
        return new NativeLibrary(libraryName, libraryPath, handle, options);
    }

    private String getLibraryName(String libraryName) {
        String suffix;
        int suffixStart;
        String simplified = libraryName;
        String BASE = "---";
        String template2 = NativeLibrary.mapLibraryName("---");
        int prefixEnd = template2.indexOf("---");
        if (prefixEnd > 0 && simplified.startsWith(template2.substring(0, prefixEnd))) {
            simplified = simplified.substring(prefixEnd);
        }
        if ((suffixStart = simplified.indexOf(suffix = template2.substring(prefixEnd + "---".length()))) != -1) {
            simplified = simplified.substring(0, suffixStart);
        }
        return simplified;
    }

    public static final NativeLibrary getInstance(String libraryName) {
        return NativeLibrary.getInstance(libraryName, Collections.EMPTY_MAP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final NativeLibrary getInstance(String libraryName, Map options) {
        if ((options = new HashMap<String, Integer>(options)).get("calling-convention") == null) {
            options.put("calling-convention", new Integer(0));
        }
        if (Platform.isLinux() && "c".equals(libraryName)) {
            libraryName = null;
        }
        Map map2 = libraries;
        synchronized (map2) {
            NativeLibrary library;
            WeakReference<NativeLibrary> ref2 = (WeakReference<NativeLibrary>)libraries.get(libraryName + options);
            NativeLibrary nativeLibrary = library = ref2 != null ? (NativeLibrary)ref2.get() : null;
            if (library == null) {
                library = libraryName == null ? new NativeLibrary("<process>", null, Native.open(null), options) : NativeLibrary.loadLibrary(libraryName, options);
                ref2 = new WeakReference<NativeLibrary>(library);
                libraries.put(library.getName() + options, ref2);
                File file2 = library.getFile();
                if (file2 != null) {
                    libraries.put(file2.getAbsolutePath() + options, ref2);
                    libraries.put(file2.getName() + options, ref2);
                }
            }
            return library;
        }
    }

    public static final synchronized NativeLibrary getProcess() {
        return NativeLibrary.getInstance(null);
    }

    public static final synchronized NativeLibrary getProcess(Map options) {
        return NativeLibrary.getInstance(null, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addSearchPath(String libraryName, String path2) {
        Map map2 = searchPaths;
        synchronized (map2) {
            List<String> customPaths = (List<String>)searchPaths.get(libraryName);
            if (customPaths == null) {
                customPaths = Collections.synchronizedList(new LinkedList());
                searchPaths.put(libraryName, customPaths);
            }
            customPaths.add(path2);
        }
    }

    public Function getFunction(String functionName) {
        return this.getFunction(functionName, this.callFlags);
    }

    Function getFunction(String name2, Method method) {
        int flags = this.callFlags;
        Class<?>[] etypes = method.getExceptionTypes();
        for (int i = 0; i < etypes.length; ++i) {
            if (!(class$com$sun$jna$LastErrorException == null ? NativeLibrary.class$("com.sun.jna.LastErrorException") : class$com$sun$jna$LastErrorException).isAssignableFrom(etypes[i])) continue;
            flags |= 4;
        }
        return this.getFunction(name2, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function getFunction(String functionName, int callFlags) {
        if (functionName == null) {
            throw new NullPointerException("Function name may not be null");
        }
        Map map2 = this.functions;
        synchronized (map2) {
            String key2 = NativeLibrary.functionKey(functionName, callFlags);
            Function function = (Function)this.functions.get(key2);
            if (function == null) {
                function = new Function(this, functionName, callFlags);
                this.functions.put(key2, function);
            }
            return function;
        }
    }

    public Map getOptions() {
        return this.options;
    }

    public Pointer getGlobalVariableAddress(String symbolName) {
        try {
            return new Pointer(this.getSymbolAddress(symbolName));
        }
        catch (UnsatisfiedLinkError e2) {
            throw new UnsatisfiedLinkError("Error looking up '" + symbolName + "': " + e2.getMessage());
        }
    }

    long getSymbolAddress(String name2) {
        if (this.handle == 0L) {
            throw new UnsatisfiedLinkError("Library has been unloaded");
        }
        return Native.findSymbol(this.handle, name2);
    }

    public String toString() {
        return "Native Library <" + this.libraryPath + "@" + this.handle + ">";
    }

    public String getName() {
        return this.libraryName;
    }

    public File getFile() {
        if (this.libraryPath == null) {
            return null;
        }
        return new File(this.libraryPath);
    }

    protected void finalize() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeAll() {
        HashSet values;
        Map map2 = libraries;
        synchronized (map2) {
            values = new HashSet(libraries.values());
        }
        Iterator i = values.iterator();
        while (i.hasNext()) {
            WeakReference ref2 = (WeakReference)i.next();
            NativeLibrary lib = (NativeLibrary)ref2.get();
            if (lib == null) continue;
            lib.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = libraries;
        synchronized (object) {
            Iterator i = libraries.values().iterator();
            while (i.hasNext()) {
                WeakReference ref2 = (WeakReference)i.next();
                if (ref2.get() != this) continue;
                i.remove();
            }
        }
        object = this;
        synchronized (object) {
            if (this.handle != 0L) {
                Native.close(this.handle);
                this.handle = 0L;
            }
        }
    }

    private static List initPaths(String key2) {
        String value = System.getProperty(key2, "");
        if ("".equals(value)) {
            return Collections.EMPTY_LIST;
        }
        StringTokenizer st = new StringTokenizer(value, File.pathSeparator);
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String path2 = st.nextToken();
            if ("".equals(path2)) continue;
            list.add(path2);
        }
        return list;
    }

    private static String findLibraryPath(String libName, List searchPath) {
        if (new File(libName).isAbsolute()) {
            return libName;
        }
        String name2 = NativeLibrary.mapLibraryName(libName);
        Iterator it = searchPath.iterator();
        while (it.hasNext()) {
            String path2 = (String)it.next();
            File file2 = new File(path2, name2);
            if (file2.exists()) {
                return file2.getAbsolutePath();
            }
            if (!Platform.isMac() || !name2.endsWith(".dylib") || !(file2 = new File(path2, name2.substring(0, name2.lastIndexOf(".dylib")) + ".jnilib")).exists()) continue;
            return file2.getAbsolutePath();
        }
        return name2;
    }

    private static String mapLibraryName(String libName) {
        if (Platform.isMac()) {
            if (libName.startsWith("lib") && (libName.endsWith(".dylib") || libName.endsWith(".jnilib"))) {
                return libName;
            }
            String name2 = System.mapLibraryName(libName);
            if (name2.endsWith(".jnilib")) {
                return name2.substring(0, name2.lastIndexOf(".jnilib")) + ".dylib";
            }
            return name2;
        }
        if (Platform.isLinux() ? NativeLibrary.isVersionedName(libName) || libName.endsWith(".so") : Platform.isWindows() && (libName.endsWith(".drv") || libName.endsWith(".dll"))) {
            return libName;
        }
        return System.mapLibraryName(libName);
    }

    private static boolean isVersionedName(String name2) {
        int so;
        if (name2.startsWith("lib") && (so = name2.lastIndexOf(".so.")) != -1 && so + 4 < name2.length()) {
            for (int i = so + 4; i < name2.length(); ++i) {
                char ch = name2.charAt(i);
                if (Character.isDigit(ch) || ch == '.') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static String matchLibrary(final String libName, List searchPath) {
        File lib = new File(libName);
        if (lib.isAbsolute()) {
            searchPath = Arrays.asList(lib.getParent());
        }
        FilenameFilter filter2 = new FilenameFilter(){

            public boolean accept(File dir2, String filename) {
                return (filename.startsWith("lib" + libName + ".so") || filename.startsWith(libName + ".so") && libName.startsWith("lib")) && NativeLibrary.isVersionedName(filename);
            }
        };
        LinkedList<File> matches = new LinkedList<File>();
        Iterator<String> it = searchPath.iterator();
        while (it.hasNext()) {
            File[] files = new File(it.next()).listFiles(filter2);
            if (files == null || files.length <= 0) continue;
            matches.addAll(Arrays.asList(files));
        }
        double bestVersion = -1.0;
        String bestMatch = null;
        Iterator it2 = matches.iterator();
        while (it2.hasNext()) {
            String path2 = ((File)it2.next()).getAbsolutePath();
            String ver = path2.substring(path2.lastIndexOf(".so.") + 4);
            double version = NativeLibrary.parseVersion(ver);
            if (!(version > bestVersion)) continue;
            bestVersion = version;
            bestMatch = path2;
        }
        return bestMatch;
    }

    static double parseVersion(String ver) {
        double v = 0.0;
        double divisor = 1.0;
        int dot = ver.indexOf(".");
        while (ver != null) {
            String num2;
            if (dot != -1) {
                num2 = ver.substring(0, dot);
                ver = ver.substring(dot + 1);
                dot = ver.indexOf(".");
            } else {
                num2 = ver;
                ver = null;
            }
            try {
                v += (double)Integer.parseInt(num2) / divisor;
            }
            catch (NumberFormatException e2) {
                return 0.0;
            }
            divisor *= 100.0;
        }
        return v;
    }

    static {
        if (Native.POINTER_SIZE == 0) {
            throw new Error("Native library not initialized");
        }
        String webstartPath = Native.getWebStartLibraryPath("jnidispatch");
        if (webstartPath != null) {
            librarySearchPath.add(webstartPath);
        }
        if (System.getProperty("jna.platform.library.path") == null && !Platform.isWindows()) {
            String platformPath = "";
            String sep = "";
            String archPath = "";
            if (Platform.isLinux() || Platform.isSolaris() || Platform.isFreeBSD()) {
                archPath = (Platform.isSolaris() ? "/" : "") + Pointer.SIZE * 8;
            }
            String[] paths = new String[]{"/usr/lib" + archPath, "/lib" + archPath, "/usr/lib", "/lib"};
            if (Platform.isLinux()) {
                String cpu = "";
                String kernel = "linux";
                String libc = "gnu";
                if (Platform.isIntel()) {
                    cpu = Platform.is64Bit() ? "x86_64" : "i386";
                } else if (Platform.isPPC()) {
                    cpu = Platform.is64Bit() ? "powerpc64" : "powerpc";
                } else if (Platform.isARM()) {
                    cpu = "arm";
                    libc = "gnueabi";
                }
                String multiArchPath = cpu + "-" + kernel + "-" + libc;
                paths = new String[]{"/usr/lib/" + multiArchPath, "/lib/" + multiArchPath, "/usr/lib" + archPath, "/lib" + archPath, "/usr/lib", "/lib"};
            }
            for (int i = 0; i < paths.length; ++i) {
                File dir2 = new File(paths[i]);
                if (!dir2.exists() || !dir2.isDirectory()) continue;
                platformPath = platformPath + sep + paths[i];
                sep = File.pathSeparator;
            }
            if (!"".equals(platformPath)) {
                System.setProperty("jna.platform.library.path", platformPath);
            }
        }
        librarySearchPath.addAll(NativeLibrary.initPaths("jna.platform.library.path"));
    }
}

