/*
 * Decompiled with CFR 0.152.
 */
package org.ccil.cowan.tagsoup;

import org.ccil.cowan.tagsoup.AttributesImpl;
import org.ccil.cowan.tagsoup.Schema;

public class ElementType {
    private String theName;
    private String theNamespace;
    private String theLocalName;
    private int theModel;
    private int theMemberOf;
    private int theFlags;
    private AttributesImpl theAtts;
    private ElementType theParent;
    private Schema theSchema;

    public ElementType(String name2, int model, int memberOf, int flags, Schema schema) {
        this.theName = name2;
        this.theModel = model;
        this.theMemberOf = memberOf;
        this.theFlags = flags;
        this.theAtts = new AttributesImpl();
        this.theSchema = schema;
        this.theNamespace = this.namespace(name2, false);
        this.theLocalName = this.localName(name2);
    }

    public String namespace(String name2, boolean attribute) {
        int colon = name2.indexOf(58);
        if (colon == -1) {
            return attribute ? "" : this.theSchema.getURI();
        }
        String prefix = name2.substring(0, colon);
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return ("urn:x-prefix:" + prefix).intern();
    }

    public String localName(String name2) {
        int colon = name2.indexOf(58);
        if (colon == -1) {
            return name2;
        }
        return name2.substring(colon + 1).intern();
    }

    public String name() {
        return this.theName;
    }

    public String namespace() {
        return this.theNamespace;
    }

    public String localName() {
        return this.theLocalName;
    }

    public int model() {
        return this.theModel;
    }

    public int memberOf() {
        return this.theMemberOf;
    }

    public int flags() {
        return this.theFlags;
    }

    public AttributesImpl atts() {
        return this.theAtts;
    }

    public ElementType parent() {
        return this.theParent;
    }

    public Schema schema() {
        return this.theSchema;
    }

    public boolean canContain(ElementType other) {
        return (this.theModel & other.theMemberOf) != 0;
    }

    public void setAttribute(AttributesImpl atts, String name2, String type2, String value) {
        if (name2.equals("xmlns") || name2.startsWith("xmlns:")) {
            return;
        }
        String namespace2 = this.namespace(name2, true);
        String localName = this.localName(name2);
        int i = atts.getIndex(name2);
        if (i == -1) {
            name2 = name2.intern();
            if (type2 == null) {
                type2 = "CDATA";
            }
            if (!type2.equals("CDATA")) {
                value = ElementType.normalize(value);
            }
            atts.addAttribute(namespace2, localName, name2, type2, value);
        } else {
            if (type2 == null) {
                type2 = atts.getType(i);
            }
            if (!type2.equals("CDATA")) {
                value = ElementType.normalize(value);
            }
            atts.setAttribute(i, namespace2, localName, name2, type2, value);
        }
    }

    public static String normalize(String value) {
        if (value == null) {
            return value;
        }
        if ((value = value.trim()).indexOf("  ") == -1) {
            return value;
        }
        boolean space = false;
        int len = value.length();
        StringBuffer b = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char v = value.charAt(i);
            if (v == ' ') {
                if (!space) {
                    b.append(v);
                }
                space = true;
                continue;
            }
            b.append(v);
            space = false;
        }
        return b.toString();
    }

    public void setAttribute(String name2, String type2, String value) {
        this.setAttribute(this.theAtts, name2, type2, value);
    }

    public void setModel(int model) {
        this.theModel = model;
    }

    public void setMemberOf(int memberOf) {
        this.theMemberOf = memberOf;
    }

    public void setFlags(int flags) {
        this.theFlags = flags;
    }

    public void setParent(ElementType parent) {
        this.theParent = parent;
    }
}

