(ns myns
  (:require [clojure.algo.monads :as m]
            [clojure.core.typed :refer :all]))

(def-alias Monad
  (TFn [[m :< (TFn [[x :variance :covariant]] x)]]
       '{:m-bind (All [x y]
                      [(m x) [x -> (m y)] -> (m y)])
         :m-result (All [x]
                        [x -> (m x)])
         ;; :m-zero Undefined
         ;; :m-plus Undefined
         }))


(def-alias State
  (TFn [[r :variance :covariant]
        [s :variance :invariant]]
       [s -> '[r s]]))

(ann ^:no-check clojure.algo.monads/state-m
     (All [s]
          (Monad (TFn [[x :variance :covariant]]
                      (State x s)))))


;; (cf ((let [m-bind (:m-bind m/state-m)
;;            m-result (:m-result m/state-m)]
;;        (m-bind (fn> [s :- (HMap)] [(:a s) s])
;;                (fn> [n :- Number]
;;                     (m-result (* n 2)))))
;;      {:a 10}))
