package com.phonepe.intent.sdk.api;

import android.support.annotation.NonNull;

import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.models.DefaultJsonImpl;
import com.phonepe.intent.sdk.networking.NetworkConstants;
import com.phonepe.intent.sdk.utils.AnalyticsManager;
import com.phonepe.intent.sdk.utils.SdkLogger;
import com.phonepe.intent.sdk.utils.Utils;

import java.util.HashMap;
import java.util.Map;

import static com.phonepe.intent.sdk.utils.AnalyticsManager.Events.SDK_AVAILABILITY_CHECK_REQUEST_CREATED;

public class AvailabilityCheckRequest extends DefaultJsonImpl {

    private String checksum;
    private String data;
    private Map<String, String> headers;

    public AvailabilityCheckRequest() {
        this.headers = new HashMap<>();
    }

    public String getChecksum() {
        return checksum;
    }

    public String getData() {
        return data;
    }

    public Map<String, String> getHeaderMap() {
        headers.put(NetworkConstants.KEY_X_VERIFY, checksum);
        return headers;
    }

    public static class AvailabilityCheckRequestBuilder {

        private static final String TAG = "AvailabilityCheckRequest";
        private String data;
        private String checksum;

        public AvailabilityCheckRequestBuilder setChecksum(@NonNull String checksum) {
            this.checksum = checksum;
            return this;
        }

        public AvailabilityCheckRequestBuilder setData(@NonNull String data) {
            this.data = data;
            return this;
        }

        public AvailabilityCheckRequest build() {

            if (Utils.isNullOrEmpty(this.checksum)) {
                SdkLogger.e(TAG, "Setting checksum is mandatory.");
                throw new RuntimeException("Setting checksum is mandatory.");
            }

            if (Utils.isNullOrEmpty(this.data)) {
                SdkLogger.e(TAG, "Setting data is mandatory.");
                throw new RuntimeException("Setting data is mandatory.");
            }

            AvailabilityCheckRequest availabilityCheckRequest = new AvailabilityCheckRequest();
            availabilityCheckRequest.checksum = this.checksum;
            availabilityCheckRequest.data = this.data;

            ObjectFactory objectFactory;
            try {
                objectFactory = PhonePe.getObjectFactory();
                AnalyticsManager analyticsManager = objectFactory.<AnalyticsManager>get(AnalyticsManager.class);
                analyticsManager.submit(analyticsManager.getEvent(SDK_AVAILABILITY_CHECK_REQUEST_CREATED));
            } catch (PhonePeInitException e) {
                SdkLogger.e(TAG, e.getMessage(), e);
            }
            return availabilityCheckRequest;
        }
    }


}