package com.phonepe.intent.sdk.api;

import android.os.Parcel;
import android.os.Parcelable;

import com.phonepe.intent.sdk.models.AbstractJson;
import com.phonepe.intent.sdk.models.DefaultJsonImpl;

import org.json.JSONObject;

public class AvailabilityCheckResponse extends DefaultJsonImpl implements Parcelable {

    private static final String KEY_CODE = "code";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_DATA = "data";
    private static final String KEY_AVAILABLE = "available";
    private static final String KEY_RESPONSE_CODE = "responseCode";
    private static final String KEY_CODE_SUCCESS = "SUCCESS";

    public String getCode() { return get(KEY_CODE); }

    public boolean isSuccess() {
        return getCode() != null && (getCode().matches(KEY_CODE_SUCCESS));
    }

    public String getMessage() {
        return get(KEY_MESSAGE);
    }

    private JSONObject getData() {
        return this.<JSONObject>get(KEY_DATA);
    }

    public Boolean isAvailable() {
        return AbstractJson.<Boolean>get(getData(), KEY_AVAILABLE);
    }

    public String getResponseCode() {
        return AbstractJson.get(getData(), KEY_RESPONSE_CODE);
    }

    @Override
    public int describeContents() {
        return super.describeContents();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
    }

}
