package com.phonepe.intent.sdk.api;

import android.os.Parcel;
import android.os.Parcelable;

import com.phonepe.intent.sdk.models.DefaultJsonImpl;

import org.json.JSONObject;

public class SDKConfigResponse extends DefaultJsonImpl implements Parcelable {

    private static final String KEY_CODE = "code";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_DATA = "data";
    private static final String KEY_CODE_SUCCESS = "SUCCESS";

    public String getCode() { return get(KEY_CODE); }

    public boolean isSuccess() {
        return getCode() != null && (getCode().matches(KEY_CODE_SUCCESS));
    }

    public String getMessage() {
        return get(KEY_MESSAGE);
    }

    public JSONObject getData() {
        return this.<JSONObject>get(KEY_DATA);
    }

    @Override
    public int describeContents() {
        return super.describeContents();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
    }

}
