package com.phonepe.intent.sdk.api;

import android.support.annotation.NonNull;

import java.util.HashMap;

public class TransactionRequestBuilder {

    private TransactionRequest.TransactionRequestBuilder transactionRequestBuilder;

    public TransactionRequestBuilder() {
        transactionRequestBuilder = new TransactionRequest.TransactionRequestBuilder();
    }

    public TransactionRequestBuilder setChecksum(@NonNull String checksum) {
        transactionRequestBuilder.setChecksum(checksum);
        return this;
    }

    public TransactionRequestBuilder setUrl(@NonNull String apiUrl) {
        transactionRequestBuilder.setUrl(apiUrl);
        return this;
    }

    public TransactionRequestBuilder setData(@NonNull String data) {
        transactionRequestBuilder.setData(data);
        return this;
    }

    public TransactionRequestBuilder setRedirectUrl(@NonNull String redirectUrl) {
        transactionRequestBuilder.setRedirectUrl(redirectUrl);
        return this;
    }


    public TransactionRequestBuilder setHeaders(@NonNull HashMap<String, String> headers) {
        transactionRequestBuilder.setHeaders(headers);
        return this;
    }

    public TransactionRequest build() {
        return transactionRequestBuilder.build();
    }

}
