package com.phonepe.intent.sdk.authandcapture.network.request;

import android.support.annotation.NonNull;
import com.phonepe.intent.sdk.models.DefaultJsonImpl;

public class AuthRequest extends DefaultJsonImpl {

    private static final String KEY_MERCHANT_ID = "merchantId";
    private static final String KEY_TRANSACTION_ID = "transactionId";
    private static final String KEY_USER_AUTH_TOKEN = "userAuthToken";
    private static final String KEY_AMOUNT = "amount";
    private static final String KEY_EXPIRY = "expiry";
    private static final String KEY_INSTRUMENT_SCOPE = "instrumentScope";
    private static final String KEY_MERCHANT_ORDER_ID = "merchantOrderId";
    private static final String KEY_MESSAGE = "message";

    public void setMerchantId(@NonNull String merchantId) {
        put(KEY_MERCHANT_ID, merchantId);
    }

    public void setTransactionId(@NonNull String transactionId) {
        put(KEY_TRANSACTION_ID, transactionId);
    }

    public void setUserAuthToken(@NonNull String userAuthToken) {
        put(KEY_USER_AUTH_TOKEN, userAuthToken);
    }

    public void setAmount(@NonNull Long amount) {
        put(KEY_AMOUNT,amount);
    }

    public void setExpiry(@NonNull Long expiry) {
        put(KEY_EXPIRY,expiry);
    }

    public void setInstrumentScope(@NonNull InstrumentScope instrumentScope) {
        put(KEY_INSTRUMENT_SCOPE, instrumentScope.name());
    }

    public void setMerchantOrderId(String merchantOrderId) {
        put(KEY_MERCHANT_ORDER_ID, merchantOrderId);
    }

    public void setMessage(String message) {
        put(KEY_MESSAGE, message);
    }


}