package com.phonepe.intent.sdk.authandcapture.network.response;

import android.support.annotation.NonNull;

import com.phonepe.intent.sdk.api.PhonePe;
import com.phonepe.intent.sdk.api.PhonePeInitException;
import com.phonepe.intent.sdk.models.DefaultJsonImpl;

import org.json.JSONObject;

public class CaptureResponse extends DefaultJsonImpl {

    private static final String KEY_SUCCESS = "success";
    private static final String KEY_CODE = "code";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_DATA = "data";

    public String getSuccess() {
        return get(KEY_SUCCESS);
    }

    public void setSuccess(@NonNull Boolean success) {
        put(KEY_SUCCESS, success);
    }

    public String getCode() {
        return get(KEY_CODE);
    }

    public void setCode(@NonNull String code) {
        put(KEY_CODE, code);
    }

    public String getMessage() {
        return get(KEY_MESSAGE);
    }

    public void setMessage(String message) {
        put(KEY_MESSAGE, message);
    }

    // TODO: find a better way of doing this
    public CaptureResponseData getData() throws PhonePeInitException {
        return fromJsonString(get(KEY_DATA).toString(), PhonePe.getObjectFactory(), CaptureResponseData.class);
    }

    public void setData(@NonNull JSONObject data){
        put(KEY_DATA, data);
    }
    public class CaptureResponseData extends DefaultJsonImpl{

        private static final String KEY_AMOUNT = "amount";
        private static final String KEY_TRANSACTION_ID = "transactionId";
        private static final String KEY_PROVIDER_REFERENCE_ID = "providerReferenceId";
        private static final String KEY_AUTH_STATE = "authState";

        public String getProviderReferenceId() {
            return get(KEY_PROVIDER_REFERENCE_ID);
        }

        public void setProviderReferenceId(String providerReferenceId) {
            put(KEY_PROVIDER_REFERENCE_ID, providerReferenceId);
        }

        public String getTransactionId() {
            return get(KEY_TRANSACTION_ID);
        }

        public void setTransactionId(@NonNull String transactionId) {
            put(KEY_TRANSACTION_ID, transactionId);
        }

        public Long getAmount() {
            return get(KEY_AMOUNT);
        }

        public void setAmount(Long amount) {
            put(KEY_AMOUNT, amount);
        }

        public AuthState getAuthState() {
            return AuthState.valueOf(get(KEY_AUTH_STATE).toString());
        }

        public void setAuthState(String authState) {
            put(KEY_AUTH_STATE, authState);
        }

    }

}
