package com.phonepe.intent.sdk.bridges;

import android.webkit.JavascriptInterface;

import com.phonepe.intent.sdk.contracts.iBridgeCallback;
import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.core.ObjectFactoryInitializationStrategy;
import com.phonepe.intent.sdk.models.UrlConfigData;
import com.phonepe.intent.sdk.ui.BaseWebActivity;
import com.phonepe.intent.sdk.utils.RuntimeExceptionManager;
import com.phonepe.intent.sdk.utils.SdkLogger;

/**
 * @author TheEternalWitness
 * @since 02/04/18.
 */
public class BridgeHandler implements ObjectFactoryInitializationStrategy {

    public static final String TAG = "NativeSDK";
    private iBridgeCallback bridgeCallback;
    private ObjectFactory objectFactory;

    @JavascriptInterface
    public void onTransactionComplete(String paymentResponse) {
        SdkLogger.d(TAG, String.format("onTransactionComplete: paymentResponse = {%s}", paymentResponse));
        this.bridgeCallback.onComplete(paymentResponse);
    }

    @JavascriptInterface
    public void onJSLoadStateChanged(String context, String isJSLoaded, String callback) {
        SdkLogger.d(TAG, String.format("onJSLoadStateChanged: isJSLoaded = {%s}", isJSLoaded));
        this.bridgeCallback.onJSLoadStateChanged(context, isJSLoaded, callback);
    }

    @JavascriptInterface
    public void setUrlConfig(String jsData) {
        SdkLogger.d(TAG, String.format("setUrlConfig : jsData = {%s}", jsData));
        if (jsData != null && jsData.length() > 0 && this.bridgeCallback != null) {

            UrlConfigData urlConfig = UrlConfigData.fromJson(jsData,this.objectFactory);
            if (urlConfig != null && urlConfig.getUrlConfig() != null) {
                this.bridgeCallback.keepUrl(urlConfig.getUrlConfig());
                return;
            }
        }

        String message = String.format("setUrlConfig is called with jsData = {%s}. bridgeCallback is null = {%s}", jsData, this.bridgeCallback == null);
        SdkLogger.e(TAG, message);
        this.objectFactory.getRuntimeExceptionManager().submit(TAG, message, RuntimeExceptionManager.Severity.LOW);
    }

    @JavascriptInterface
    public void showLoader(String context, String showLoader, String callback) {
        SdkLogger.d(TAG, String.format("showLoader: shouldShowLoader = {%s}", showLoader));
        this.bridgeCallback.showLoader(context, showLoader, callback);
    }

    @Override
    public void init(ObjectFactory objectFactory, ObjectFactory.InitializationBundle initializationBundle) {

        this.bridgeCallback = initializationBundle.<iBridgeCallback>get(BaseWebActivity.BRIDGE_CALLBACK, null);
        this.objectFactory = objectFactory;
    }

    @Override
    public boolean isCachingAllowed() {
        return false;
    }

    protected ObjectFactory getObjectFactory() {

        return this.objectFactory;
    }
}
