package com.phonepe.intent.sdk.comunication;

import android.app.Service;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.AsyncTask;
import android.os.IBinder;
import android.os.RemoteException;

import com.phonepe.app.external.sdksupport.MerchantBridge;
import com.phonepe.intent.sdk.api.RequestCallback;
import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.core.ObjectFactoryInitializationStrategy;
import com.phonepe.intent.sdk.utils.SdkLogger;
import com.phonepe.intent.sdk.utils.Utils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Calendar;

public class SDKtoAppConnection implements ObjectFactoryInitializationStrategy, ServiceConnection {

    public static final String KEY_REQUEST = "request";
    public static final String KEY_CONSTRAINTS = "constraints";
    public static final String KEY_CALLBACK = "callback";
    public static final String VALUE_SHOULDSHOWPHONEPE = "shouldShowPhonePe";
    public static final String VALUE_LOGGED_IN = "loggedIn";
    public static final String VALUE_SUPPORTED_URI_SCHEMAS = "supportedUriSchemas";
    public static final String VALUE_PAYMENTINSTRUMENT = "singlePaymentInstrumentAvailable";
    public static final String VALUE_MERCHANT_APP_ID = "merchantAppId";
    public static final String KEY_RESULT = "result";
    public static final String KEY_PHONEPE_RESPONDED = "phonepeResponded";
    public static final String KEY_TIMESTAMP = "timestamp";
    private static final String MERCHANT_SERVICE_CLASS = "com.phonepe.app.external.sdksupport.MerchantService";
    private static final String MERCHANT_SERVICE_ACTION = "com.phonepe.app.remote.service.MERCHANTSERVICE";
    private static final long FIVE_MINUTES = 1000*60*5;

    private static final String TAG = "SDKtoAppConnection";

    private ObjectFactory objectFactory;
    private String request;
    private String constraints;
    private RequestCallback requestCallback;
    private String merchantAppPackageName;
    MerchantBridge merchantPaymentBridge;

    @Override
    public void onServiceConnected(ComponentName name, IBinder service) {
        merchantPaymentBridge = MerchantBridge.Stub.asInterface(service);
        if(task.getStatus() == AsyncTask.Status.PENDING) {
            task.execute();
        }
    }

    @Override
    public void onServiceDisconnected(ComponentName name) {
        SdkLogger.d(TAG, "onServiceDisconnected: "+name.flattenToString());
        if(task.getStatus() == AsyncTask.Status.PENDING) {
            sendFailureResponse();
        }
    }

    @Override
    public void onBindingDied(ComponentName name) {
        SdkLogger.d(TAG, "onBindingDied: "+name.flattenToString());
        if (task.getStatus() == AsyncTask.Status.PENDING) {
            sendFailureResponse();
        }
    }

    AsyncTask<Void, Void, String> task = new AsyncTask<Void, Void, String>() {
        @Override
        protected String doInBackground(Void... voids) {
            try {
                SdkLogger.d(TAG, "Making Request");
                String response = merchantPaymentBridge.request(request, constraints, merchantAppPackageName);
                JSONObject data = new JSONObject(response);
                data.put(KEY_TIMESTAMP, System.currentTimeMillis());
                objectFactory.cache(request, response);
                return response;

            } catch (Exception e) {
                SdkLogger.e(TAG, "CAUGHT EXCEPTION: "+e.getMessage(), e);
                return null;
            }
        }

        @Override
        protected void onPostExecute(String response) {
            super.onPostExecute(response);
            sendResponse(response);
            objectFactory.getApplicationContext().unbindService(SDKtoAppConnection.this);
        }
    };

    @Override
    public void init(ObjectFactory objectFactory, ObjectFactory.InitializationBundle initializationBundle) {
        this.objectFactory = objectFactory;
        request = initializationBundle.<String>get(KEY_REQUEST, null);
        constraints = initializationBundle.<String>get(KEY_CONSTRAINTS, null);
        requestCallback = initializationBundle.<RequestCallback>get(KEY_CALLBACK, null);
        if(objectFactory.get(request) != null) {
            try {
                String response = objectFactory.get(request);
                JSONObject data = new JSONObject(response);
                if(data.has(KEY_TIMESTAMP)) {
                    long timestamp = data.getLong(KEY_TIMESTAMP);
                    if(System.currentTimeMillis()-timestamp >= FIVE_MINUTES) {
                        SdkLogger.d(TAG, "Sending Cached Response");
                        sendResponse(response);
                        return;
                    } else {
                        SdkLogger.d(TAG, "Cached Data expired fetching again.");
                    }
                }
            } catch (Exception e) {
                SdkLogger.e(TAG, e.getMessage(), e);
            }
        }
        Intent it = new Intent();
        it.setAction(MERCHANT_SERVICE_ACTION);
        String phonePePackageName = Utils.getPhonePePackageName(objectFactory);
        it.setComponent(new ComponentName(phonePePackageName, MERCHANT_SERVICE_CLASS));
        it.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
        merchantAppPackageName = objectFactory.getApplicationContext().getPackageName();
        boolean result = false;
        int count = 0;
        while(count < 20) {
            count++;
            result = objectFactory.getApplicationContext().bindService(it, this, Service.BIND_AUTO_CREATE);
            if(result) break;
        }
        if(!result) {
            sendFailureResponse();

        }
        SdkLogger.d(TAG, "initConnection: Result: "+result+" Count: "+count+" Thread: "+Thread.currentThread().getName());
    }

    @Override
    public boolean isCachingAllowed() {
        return false;
    }

    private void sendFailureResponse() {
        JSONObject response = new JSONObject();
        try {
            response.put(KEY_RESULT, false);
            response.put(KEY_PHONEPE_RESPONDED, false);
            sendResponse(response.toString());
        } catch (JSONException e) {
            e.printStackTrace();
            sendResponse(null);
        }
    }

    private synchronized void sendResponse(String response) {
        if(requestCallback != null) {
            SdkLogger.d(TAG, "Got Response");
            requestCallback.onResponse(response);
            requestCallback = null;
        }
    }

}
