package com.phonepe.intent.sdk.core;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;

import java.util.HashSet;
import java.util.Set;

/**
 * Base Config class, this would take care of all the generic methods, it helps to avoid errors such as commit
 * Created by viveksoneja on 15/03/16.
 */
public abstract class BaseConfig implements ObjectFactoryInitializationStrategy {

    private ObjectFactory objectFactory;

    protected BaseConfig() {
    }

    protected ObjectFactory getObjectFactory() {

        return this.objectFactory;
    }

    @Override
    public void init(ObjectFactory objectFactory, ObjectFactory.InitializationBundle initializationBundle) {

        this.objectFactory = objectFactory;
    }

    @Override
    public boolean isCachingAllowed() {
        return true;
    }

    public void saveInteger(@NonNull String key, int value) {
        getConfigPreferenceManager().edit().putInt(key, value).apply();
    }

    public int getInt(@NonNull String key, int defaultValue) {
        return getConfigPreferenceManager().getInt(key, defaultValue);
    }

    public long getLong(@NonNull String key, long defaultValue) {
        return getConfigPreferenceManager().getLong(key, defaultValue);
    }

    public void saveLong(@NonNull String key, long value) {
        getConfigPreferenceManager().edit().putLong(key, value).apply();
    }

    public boolean getBool(@NonNull String key, boolean defaultValue) {
        return getConfigPreferenceManager().getBoolean(key, defaultValue);
    }

    public void saveString(@NonNull String key, String value) {
        getConfigPreferenceManager().edit().putString(key, value).apply();
    }

    public void saveBool(@NonNull String key, boolean value) {
        getConfigPreferenceManager().edit().putBoolean(key, value).apply();
    }

    public String getString(@NonNull String key, String defaultValue) {
        return getConfigPreferenceManager().getString(key, defaultValue);
    }

    public void saveFloat(@NonNull String key, float value) {
        getConfigPreferenceManager().edit().putFloat(key, value).apply();
    }

    public float getFloat(@NonNull String key, float defaultValue) {
        return getConfigPreferenceManager().getFloat(key, defaultValue);
    }

    public void saveStringSet(@NonNull String key, Set<String> value) {
        getConfigPreferenceManager().edit().putStringSet(key, value).apply();
    }

    public Set<String> getStringSet(@NonNull String key, HashSet<String> defaultValue) {
        return getConfigPreferenceManager().getStringSet(key, defaultValue);
    }


    protected SharedPreferences getConfigPreferenceManager() {
        return this.objectFactory.getApplicationContext().getSharedPreferences(getPreferenceName(), Context.MODE_PRIVATE);
    }

    public void clearAllData() {
        getConfigPreferenceManager().edit().clear().commit();
    }

    public boolean contains(@NonNull String key) {
        return getConfigPreferenceManager().contains(key);
    }

    public void remove(@NonNull String key) {

        getConfigPreferenceManager().edit().remove(key).commit();
    }

    /**
     * @return Should return the name of the preferences
     */
    protected abstract String getPreferenceName();

}
