package com.phonepe.intent.sdk.core;

import com.phonepe.intent.sdk.contracts.iBridgeCallback;
import com.phonepe.intent.sdk.utils.Constants;
import com.phonepe.intent.sdk.utils.SdkLogger;

public class EventLoggerJS implements ObjectFactoryInitializationStrategy {

    private String EVENT_BRIDGE_FUNCTION = "eventBridge";
    private static final String BRIDGE_CALLBACK = "bridgeCallback";
    private iBridgeCallback bridgeCallback;
    private ObjectFactory objectFactory;
    private static final String TAG = "EventLoggerJS";

    public void se(String callback, String error, String response, String context, String body) {
        this.bridgeCallback.onBridgeCallBack(callback,
                error,
                response,
                context,
                body);
    }

    public void sendEventToJS(String body) {
        se(EVENT_BRIDGE_FUNCTION, null, this.objectFactory.getResponse(Constants.GenericConstants.SUCCESS).toJsonString(), null, body);
    }

    @Override
    public void init(ObjectFactory objectFactory, ObjectFactory.InitializationBundle initializationBundle) {

        SdkLogger.d(TAG, "initializing EventLoggerJS ..");
        this.objectFactory = objectFactory;
        this.bridgeCallback = initializationBundle.<iBridgeCallback>get(BRIDGE_CALLBACK, null);
        SdkLogger.d(TAG, String.format("initialization completed bridgeCallback = {%s} is set", this.bridgeCallback));
    }

    @Override
    public boolean isCachingAllowed() {
        return false;
    }
}
