package com.phonepe.intent.sdk.core;

import android.Manifest;
import android.app.Activity;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;

import com.phonepe.intent.sdk.utils.Constants;
import com.phonepe.intent.sdk.utils.SdkLogger;


/**
 * @author Suman PPE
 * @since 05/06/17.
 */
public class PermissionUtils {

    private static final String TAG = "PermissionUtils";

    public static boolean hasPermission(@NonNull Activity activity, @NonNull String permission) {
        boolean permissionStatus = ContextCompat.checkSelfPermission(activity, permission) == PackageManager.PERMISSION_GRANTED;
        SdkLogger.d(TAG, String.format("permission status {%s : %s}", permission, permissionStatus));
        return permissionStatus;
    }

    public static void showRationaleAndRequestPermissions(Activity activity, String permission, int requestCode) {
        if (ActivityCompat.shouldShowRequestPermissionRationale(activity, permission)) {
            ActivityCompat.requestPermissions(activity, new String[]{permission}, requestCode);
        } else {
            ActivityCompat.requestPermissions(activity, new String[]{Manifest.permission.SEND_SMS}, requestCode);
        }
    }

    /**
     * Used to return predefined permission denied error codes to JS bridge
     *
     * @param permission
     * @return
     */

    public static String getPermissionDeniedCode(String permission) {
        switch (permission) {
            case Manifest.permission.READ_SMS:
                return Constants.ErrorCodes.PERMISSION_DENIED_READ_SMS;
            case Manifest.permission.SEND_SMS:
                return Constants.ErrorCodes.PERMISSION_DENIED_SEND_SMS;
            case Manifest.permission.READ_PHONE_STATE:
                return Constants.ErrorCodes.PERMISSION_DENIED_READ_PHONE_STATE;
        }
        return null;
    }


}
