package com.phonepe.intent.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.utils.Constants;
import com.phonepe.intent.sdk.utils.SdkLogger;

import org.json.JSONException;
import org.json.JSONObject;

public class DefaultJsonImpl extends AbstractJson implements Parcelable {

    private JSONObject jsonObject;
    private ObjectFactory objectFactory;
    private static final String TAG = "DefaultJsonImpl";

    public DefaultJsonImpl() {
    }

    @Override
    protected ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    protected DefaultJsonImpl(Parcel in) {
        this.objectFactory = in.readParcelable(DefaultJsonImpl.class.getClassLoader());
        this.jsonObject = this.objectFactory.getJsonObject(in.readString());
    }

    @Override
    public void init(ObjectFactory objectFactory, ObjectFactory.InitializationBundle initializationBundle) {
        super.init(objectFactory, initializationBundle);
        this.objectFactory = objectFactory;

        if (initializationBundle != null && initializationBundle.containsKey(AbstractJson.TAG)) {
            this.jsonObject = (JSONObject) initializationBundle.get(AbstractJson.TAG);
        } else {
            this.jsonObject = getObjectFactory().getJsonObject();
        }
    }

    @Override
    protected JSONObject getJsonObject() {
        return this.jsonObject;
    }

    public JSONObject toJsonObject() {

        return getJsonObject();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<DefaultJsonImpl> CREATOR = new Creator<DefaultJsonImpl>() {
        @Override
        public DefaultJsonImpl createFromParcel(Parcel in) {
            return new DefaultJsonImpl(in);
        }

        @Override
        public DefaultJsonImpl[] newArray(int size) {
            return new DefaultJsonImpl[size];
        }
    };



    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.objectFactory,flags);
        dest.writeString(getJsonObject().toString());
    }
}
