package com.phonepe.intent.sdk.models;

import com.phonepe.intent.sdk.core.ObjectFactory;

import org.json.JSONObject;

import static com.phonepe.intent.sdk.utils.AnalyticsManager.EventConstants.EVENT_TIME;
import static com.phonepe.intent.sdk.utils.AnalyticsManager.EventConstants.INTENT_SUPPORTED;
import static com.phonepe.intent.sdk.utils.AnalyticsManager.EventConstants.KEY_DATA;
import static com.phonepe.intent.sdk.utils.AnalyticsManager.EventConstants.KEY_EVENT_NAME;

/**
 * Date 20/06/17
 *
 * @author Ankit Jain
 */
public class Event extends DefaultJsonImpl {

    public static final String TAG = "Event";

    public Event setEventName(String eventName) {
        this.<String>put(KEY_EVENT_NAME, eventName);
        return this;
    }

    public String getEventName() {

        return get(KEY_EVENT_NAME);
    }

    public <T> Event putInEventBody(String key, T value) {

        put(this.<JSONObject>get(KEY_DATA), getObjectFactory(), key, value);
        return this;
    }

    @Override
    public void init(ObjectFactory objectFactory, ObjectFactory.InitializationBundle initializationBundle) {
        super.init(objectFactory, initializationBundle);
        JSONObject jsonObject = objectFactory.getJsonObject();
        this.<JSONObject>put(KEY_DATA, jsonObject);
        this.<Long>put(EVENT_TIME, System.currentTimeMillis());
        this.putInEventBody(INTENT_SUPPORTED, String.valueOf(true));
    }
}
