package com.phonepe.intent.sdk.models;

import android.support.annotation.NonNull;

import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.utils.Constants;

import org.json.JSONArray;
import org.json.JSONObject;

public class EventsPayload extends DefaultJsonImpl {

    public static final String KEY_TIME = "currentSdkTime";
    public static final String KEY_SDK_CONTEXT = "sdkContext";
    public static final String KEY_EVENTS = "events";
    public static final String KEY_TRANSACTION_ID = "transactionId";

    @Override
    public void init(ObjectFactory objectFactory, ObjectFactory.InitializationBundle initializationBundle) {
        super.init(objectFactory, initializationBundle);
        this.<Long>put(KEY_TIME, System.currentTimeMillis());
        this.<JSONArray>put(KEY_EVENTS, objectFactory.getJsonArray());
    }

    public void setMerchantId(@NonNull String merchantId){

        this.<String>put(Constants.GenericConstants.KEY_MERCHANT_ID, merchantId);
    }

    public void setTransactionId(@NonNull String transactionId){

        this.<String>put(KEY_TRANSACTION_ID, transactionId);
    }

    public void setSdkContext(@NonNull SDKContext sdkContext){

        this.<JSONObject>put(KEY_SDK_CONTEXT, sdkContext.toJsonObject());
    }

    public void setEvents(@NonNull String eventsJsonArray){

        JSONArray jsonArray = getObjectFactory().getJsonArray(eventsJsonArray);
        this.<JSONArray>put(KEY_EVENTS, jsonArray);
    }
}
