package com.phonepe.intent.sdk.models;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;

import com.phonepe.intent.sdk.comunication.SDKtoAppConnection;
import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.utils.Config;
import com.phonepe.intent.sdk.utils.SDKDeviceInfoProvider;
import com.phonepe.intent.sdk.utils.SdkLogger;
import com.phonepe.intent.sdk.utils.Utils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.List;

/**
 * @author TheEternalWitness
 * @since 03/04/18.
 */
public class SDKContext extends DefaultJsonImpl implements Parcelable {
    public static final String TAG = "SDKContext";
    private static final String KEY_IS_PP_APP_PRESENT = "isPPAppPresent";
    private static final String KEY_PP_VERSION_CODE = "ppVersionCode";
    private static final String KEY_PP_VERSION_NAME = "ppVersionName";
    private static final String KEY_IS_JUSPAY_SDK_INTEGRATED = "isJusPaySDKIntegrated";
    private static final String KEY_ICC_ID = "deviceIccid";
    private static final String KEY_NETWORK_TYPE = "deviceNetworkType";
    private static final String KEY_CELL_INFO = "deviceCellInfo";
    private static final String KEY_DEVICE_LOCATION = "deviceLocation";
    private static final String KEY_UPI_APPS = "upiApps";
    private static final String KEY_IS_ROOTED = "is_rooted";
    private static final String KEY_IS_CLOAKING_APPS = "is_cloaking";
    private static final String KEY_IS_DANGEROUS_APPS = "is_dangerousapps";
    private static final String KEY_IS_ROOT_MANAGER = "is_rootmanager";
    private static final String KEY_IS_TEST_KEYS = "is_testkeys";
    private static final String KEY_IS_BUSY_BOX = "is_busybox";
    private static final String KEY_IS_ROOTED_WITHOUT_BUSY_BOX = "is_rooted_nan_buysbox";
    private static final String KEY_DEVICE_ROOT_STATE = "root_state";
    private static final String KEY_PP_USER_LOGGED_IN = "loggedInOnPP";
    private static final String KEY_PP_SINGLE_INSTRUMENT_AVAILABLE = "minSinglePaymentInstrument";
    private static final String KEY_PP_SUPPORTED_URI_SCHEMAS = "supportedUriSchemas";
    private static final String KEY_SUPPORTS_TLS = "tlsVersion";
    private static final String KEY_TRANSACTION_ID = "transactionId";
    private static final String KEY_ROOTBEER_ADDED = "rootbeer_added";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String ROOTED = "ROOTED";

    public static final String DEVICE_ICC_ID_KEY = KEY_ICC_ID;

    private void addUpiApps() {

        Intent upiUriIntent = new Intent();
        upiUriIntent.setData(getObjectFactory().<Config>get(Config.class).getUpiUri());
        List<ResolveInfo> resolveInfoList = Utils.getResolveInfo(getObjectFactory(), upiUriIntent);
        List<ApplicationInfo> applicationInfoList = getObjectFactory().getArrayList();
        if(getObjectFactory() != null && getObjectFactory().getApplicationContext() != null && resolveInfoList != null) {
            PackageManager packageManager = getObjectFactory().getApplicationContext().getPackageManager();
            for (ResolveInfo resolveInfo : resolveInfoList) {
                String packageName = resolveInfo.activityInfo.packageName;
                android.content.pm.ApplicationInfo applicationInformation = resolveInfo.activityInfo.applicationInfo;
                String applicationName = packageManager.getApplicationLabel(applicationInformation).toString();
                ApplicationInfo applicationInfo = getObjectFactory().<ApplicationInfo>get(ApplicationInfo.class);
                applicationInfo.setPackageName(packageName);
                applicationInfo.setName(applicationName);
                applicationInfo.setVersion(Utils.getVersionCode(packageName, getObjectFactory()));
                applicationInfo.setActivity(resolveInfo.activityInfo.name);
                if (applicationInfo.isLastTimeUsed()) {
                    applicationInfoList.add(0, applicationInfo);
                } else {
                    applicationInfoList.add(applicationInfo);
                }
            }
        }


        this.put(KEY_UPI_APPS, covert(applicationInfoList));
    }

    private JSONArray covert(@NonNull List<ApplicationInfo> applicationInfoList) {

        JSONArray jsonArray = getObjectFactory().getJsonArray();

        for (ApplicationInfo applicationInfo : applicationInfoList) {

            jsonArray.put(applicationInfo.toJsonObject());
        }

        return jsonArray;
    }

    @Override
    public void init(ObjectFactory objectFactory, ObjectFactory.InitializationBundle initializationBundle) {
        super.init(objectFactory, initializationBundle);
        SDKDeviceInfoProvider sdkDeviceInfoProvider = getObjectFactory().<SDKDeviceInfoProvider>get(SDKDeviceInfoProvider.class);


        this.<String>put(KEY_ICC_ID, sdkDeviceInfoProvider.getICCID());
        this.<String>put(KEY_NETWORK_TYPE, sdkDeviceInfoProvider.getNetWorkType());
        this.<JSONObject>put(KEY_CELL_INFO, sdkDeviceInfoProvider.getCellInfo().toJsonObject());
        this.<JSONObject>put(KEY_DEVICE_LOCATION, sdkDeviceInfoProvider.getMyLocation().toJsonObject());
        this.<Boolean>put(KEY_IS_JUSPAY_SDK_INTEGRATED, false);
        this.<Integer>put(KEY_SUPPORTS_TLS, Build.VERSION.SDK_INT > 19 ? 2 : 1);
        addUpiApps();
        //addSecurityChecks(applicationContext);
        setPhonePeAppData();
        addConstraints();
    }

    private void addConstraints() {
        JSONArray constraints = new JSONArray();
        JSONObject allowedResponseSchema = new JSONObject();
        try {
            allowedResponseSchema.put("type", "ALLOWED_RESPONSE_SCHMEMAS");
            JSONArray jsonArray = new JSONArray();
            jsonArray.put("SDK_RESONSE_V2");
            allowedResponseSchema.put("values", jsonArray);
            constraints.put(allowedResponseSchema);
        } catch (Exception e) {
            SdkLogger.e(TAG, e.getMessage(), e);
        }
        this.put("constraints", constraints);

    }

    public void setPhonePeAppData() {
        Context applicationContext = getObjectFactory().getApplicationContext();
        String phonePePackageName = Utils.getPhonePePackageName(getObjectFactory());
        boolean isPhonePeAppExist = Utils.isAppExist(applicationContext, phonePePackageName);
        long versionCode = -1L;
        String versionName = "-1";
        try {
            PackageInfo info = applicationContext.getPackageManager().getPackageInfo(phonePePackageName, PackageManager.GET_ACTIVITIES);
            versionCode = info.versionCode;
            versionName = info.versionName;
        } catch (Exception e) {
            SdkLogger.e(SDKContext.TAG, String.format("failed to get package info for package name = {%s}, exception message = {%s}", phonePePackageName, e.getMessage()));
        }
        this.<Boolean>put(KEY_IS_PP_APP_PRESENT, isPhonePeAppExist);
        this.<Long>put(KEY_PP_VERSION_CODE, versionCode);
        this.<String>put(KEY_PP_VERSION_NAME, versionName);
        String sdkToAppCommunication = getObjectFactory().get(SDKtoAppConnection.VALUE_SHOULDSHOWPHONEPE);
        try {
            if (sdkToAppCommunication != null && !sdkToAppCommunication.isEmpty()) {
                JSONObject data = new JSONObject(sdkToAppCommunication);
                if (data.has(SDKtoAppConnection.VALUE_LOGGED_IN)) {
                    this.put(KEY_PP_USER_LOGGED_IN, data.getBoolean(SDKtoAppConnection.VALUE_LOGGED_IN));
                }

                if (data.has(SDKtoAppConnection.VALUE_PAYMENTINSTRUMENT)) {
                    this.put(KEY_PP_SINGLE_INSTRUMENT_AVAILABLE, data.getBoolean(SDKtoAppConnection.VALUE_PAYMENTINSTRUMENT));
                }

                if (data.has(SDKtoAppConnection.VALUE_SUPPORTED_URI_SCHEMAS)) {
                    this.put(KEY_PP_SUPPORTED_URI_SCHEMAS, data.getJSONArray(SDKtoAppConnection.VALUE_SUPPORTED_URI_SCHEMAS));
                }
            }
        } catch (Exception e) {
            SdkLogger.e(TAG, e.getMessage(), e);
        }
    }

    @Override
    public boolean isCachingAllowed() {
        return true;
    }


    public SDKContext() {
    }

    private SDKContext(Parcel in) {
        super(in);
    }

    public static final Creator<SDKContext> CREATOR = new Creator<SDKContext>() {
        @Override
        public SDKContext createFromParcel(Parcel in) {
            return new SDKContext(in);
        }

        @Override
        public SDKContext[] newArray(int size) {
            return new SDKContext[size];
        }
    };

    @Override
    public int describeContents() {
        return super.describeContents();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
    }
}
