package com.phonepe.intent.sdk.models;

import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.utils.GenericJSONUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * @author TheEternalWitness
 * @since 06/04/18.
 */
public class UrlConfig {

    private static final String KEY_PARAMS = "params";
    private static final String KEY_URL = "url";

    private List<Params> params;
    private String url;

    private String getParamsString() {
        List<Params> paramsList = params;
        if (paramsList == null || paramsList.size() == 0)
            return "";
        StringBuilder sb = new StringBuilder("?");
        for (int i = 0; i < paramsList.size(); i++) {
            sb.append(paramsList.get(i).getKey() + "=" + paramsList.get(i).getValue() + "&");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public String getFinalUrl(String baseUrl) {
        return url != null ? baseUrl + url + getParamsString() : null;
    }

    public static UrlConfig fromJson(JSONObject jsonObject, ObjectFactory objectFactory) throws JSONException {
        if (jsonObject == null) {
            return null;
        }
        UrlConfig urlConfig = new UrlConfig();
        List<Params> params = new ArrayList<>();
        urlConfig.url = GenericJSONUtils.readString(jsonObject, KEY_URL, false, false);
        JSONArray jsonArray = GenericJSONUtils.readJSONArray(jsonObject, KEY_PARAMS, false, false);
        if (jsonArray != null && jsonArray.length() > 0) {
            for (int i = 0; i < jsonArray.length(); i++) {

                JSONObject paramJsonObject = AbstractJson.<JSONObject>get(jsonArray, i);
                if (paramJsonObject == null) {
                    continue;
                }
                params.add(Params.fromJsonString(paramJsonObject.toString(), objectFactory, Params.class));
            }
        }

        urlConfig.params = params;


        return urlConfig;
    }

    public static UrlConfig fromJson(String res, ObjectFactory objectFactory) throws JSONException {
        JSONObject jsonObject = new JSONObject(res);
        return fromJson(jsonObject, objectFactory);
    }
}