package com.phonepe.intent.sdk.mvp;

import android.content.Intent;
import android.os.Bundle;

import com.phonepe.intent.sdk.models.IntentResponse;
import com.phonepe.intent.sdk.models.UrlConfig;

/**
 * @author TheEternalWitness
 * @since 19/04/18.
 */
public interface iTransactionPresenter {
    void onRequestReceived(Intent startIntent, Bundle savedInstanceState);

    void onBackPressed();

    void saveInstanceState(Bundle bundle);

    void onDestroy();

    void onBackPressConfirmed();

    void onBackPressCancelled();

    void onRetryPressed();

    void onActivityResult(boolean wasCanceled, IntentResponse intentResponse);

    void onJSLoadStateChanged(String context, String isJSLoaded, String callback);

    void onShowLoader(String context, String showLoader, String callback);

    void onJusPayTransactionCompleted(String transactionId, String status, boolean isSuccess);

    void onComplete(String result);

    void keepUrl(UrlConfig urlConfig);

    void onPageLoadStart(String url);

    void onPageFinished(String presentUrl);
}
