package com.phonepe.intent.sdk.networking;

import android.text.TextUtils;

import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.core.ObjectFactoryInitializationStrategy;
import com.phonepe.intent.sdk.utils.Constants;
import com.phonepe.intent.sdk.utils.SdkLogger;
import com.phonepe.intent.sdk.utils.Utils;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;


/**
 * @author TheEternalWitness
 * @since 20/04/18.
 */
public class CustomHostNameVerifier implements HostnameVerifier, ObjectFactoryInitializationStrategy {

    private ObjectFactory objectFactory;
    public static final String TAG = "CustomHostNameVerifier";

    @Override
    public boolean verify(String hostname, SSLSession sslSession) {
        Boolean isInUATMode = this.objectFactory.<Boolean>get(Constants.MerchantMeta.IS_UAT);
        String phonePeHostName = NetworkConstants.getBaseHost(Utils.isTrue(isInUATMode));
        if (!TextUtils.isEmpty(hostname) && (hostname.contains(phonePeHostName) || checkForLocalBackend(hostname))) {


            HostnameVerifier hv =
                    HttpsURLConnection.getDefaultHostnameVerifier();
            return hv.verify(phonePeHostName, sslSession);
        }
        // that means SSLSession is coming with different host so let's not allow this.
        SdkLogger.e(TAG, "Detected an SSLSession coming from an unknown host. Aborting !!!");
        return false;
    }

    private boolean checkForLocalBackend(String hostName) {
        return !TextUtils.isEmpty(NetworkConstants.BACKEND_URL) && NetworkConstants.BACKEND_URL.contains(hostName);
    }

    @Override
    public void init(ObjectFactory objectFactory, ObjectFactory.InitializationBundle initializationBundle) {

        this.objectFactory = objectFactory;
    }

    @Override
    public boolean isCachingAllowed() {
        return false;
    }
}
