package com.phonepe.intent.sdk.networking

import com.phonepe.intent.sdk.api.*
import com.phonepe.intent.sdk.models.IntentSDKConfig
import com.phonepe.intent.sdk.models.SDKContext
import com.phonepe.intent.sdk.networking.models.PhonePeContext
import com.phonepe.intent.sdk.utils.AnalyticsManager
import com.phonepe.intent.sdk.utils.Constants
import com.phonepe.intent.sdk.utils.SdkLogger

class NetworkUtils {

    companion object {

        fun checkAvailability(availabilityCheckRequest: AvailabilityCheckRequest, callback: CheckPhonePeAvailabilityInternalCallback) {
            val apiHelper = PhonePe.getObjectFactory().get(APIHelper::class.java)
            apiHelper.checkPhonePeAvailability(availabilityCheckRequest, getSDKContext(), getPhonePeContext(), object : INetworkResponseListener {
                override fun onSuccess(response: String) {
                    SdkLogger.d("checkAvailability", "onSuccess $response")
                    val availabilityCheckResponse = AvailabilityCheckResponse.fromJsonString(response, PhonePe.getObjectFactory(), AvailabilityCheckResponse::class.java)
                    availabilityCheckResponse?.let {
                        if (availabilityCheckResponse.isSuccess) {
                            SdkLogger.d("checkAvailability", "availabilityCheckResponse isPaymentSupported " + availabilityCheckResponse.isAvailable + " " + availabilityCheckResponse.responseCode)
                            callback.onSuccess(availabilityCheckResponse.isAvailable, availabilityCheckResponse.responseCode)
                            sendEvent(AnalyticsManager.Events.CHECK_AVAILABILITY_CALL_SUCCESS)
                        }
                    }
                }

                override fun onFailure(responseCode: Int, error: String) {
                    SdkLogger.d("checkAvailability", "onFailure $error")
                    callback.onFailure(false, Constants.ErrorCodes.ERROR_API_CALL_FAILED)
                    sendEvent("CHECK_AVAILABILITY_CALL_FAILED")
                }
            })
        }

        private fun sendEvent(eventName: String) {
            //TODO: body?
            val analyticsManager = PhonePe.getObjectFactory().get(AnalyticsManager::class.java)
            analyticsManager.submit(analyticsManager.getEvent(eventName))
        }

        fun syncSDKConfig() {
            val objectFactory = PhonePe.getObjectFactory()
            val isConfigSynced = objectFactory.get<Boolean?>(Constants.GenericConstants.CONFIG_SYNCED)
            if (isConfigSynced == null || isConfigSynced == false) {
                SdkLogger.d("checkAvailability", "Starting syncSDKConfig call")
                val apiHelper = objectFactory.get(APIHelper::class.java)
                apiHelper.syncSDKConfig(getSDKContext(), getPhonePeContext(),object : INetworkResponseListener {
                    override fun onSuccess(response: String) {
                        SdkLogger.d("checkAvailability", "onSuccess $response")
                        val sdkConfigResponse = SDKConfigResponse.fromJsonString(response, objectFactory, SDKConfigResponse::class.java)
                        sdkConfigResponse?.let {
                            if (sdkConfigResponse.isSuccess) {
                                SdkLogger.d("checkAvailability", "data ${sdkConfigResponse.data}")
                                val intentSDKConfig: IntentSDKConfig? = objectFactory.get(IntentSDKConfig::class.java)
                                intentSDKConfig?.updateConfig(sdkConfigResponse.data)
                            }
                        }
                    }

                    override fun onFailure(responseCode: Int, error: String) {
                        SdkLogger.d("checkAvailability", "onFailure $error")
                    }
                })
            } else {
                SdkLogger.d(PhonePe.TAG, "SDK Config present")
            }
        }

        private fun getSDKContext(): SDKContext? {
            try {
                return PhonePe.getObjectFactory().get(SDKContext::class.java)
            } catch (exception: PhonePeInitException) {
                exception.printStackTrace()
            }
            return null
        }

        private fun getPhonePeContext(): PhonePeContext? {
            try {
                return PhonePe.getObjectFactory().get(PhonePeContext::class.java)
            } catch (exception: PhonePeInitException) {
                exception.printStackTrace()
            }
            return null
        }
    }

}