package com.phonepe.intent.sdk.subscriptions.network;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.Base64;
import android.util.Log;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.phonepe.intent.sdk.BuildConfig;
import com.phonepe.intent.sdk.R;
import com.phonepe.intent.sdk.api.PhonePe;
import com.phonepe.intent.sdk.api.PhonePeInitException;
import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.models.SDKContext;
import com.phonepe.intent.sdk.networking.APIManager;
import com.phonepe.intent.sdk.networking.INetworkResponseListener;
import com.phonepe.intent.sdk.networking.NetworkConstants;
import com.phonepe.intent.sdk.networking.models.PhonePeContext;
import com.phonepe.intent.sdk.subscriptions.network.request.AuthInitRequest;
import com.phonepe.intent.sdk.subscriptions.network.request.CreateSubscriptionRequest;
import com.phonepe.intent.sdk.subscriptions.network.request.DebitInitRequest;
import com.phonepe.intent.sdk.subscriptions.network.request.SubscriptionAmountType;
import com.phonepe.intent.sdk.subscriptions.network.request.SubscriptionAuthWorkflowType;
import com.phonepe.intent.sdk.subscriptions.network.request.SubscriptionFrequency;
import com.phonepe.intent.sdk.subscriptions.network.response.AuthInitResponse;
import com.phonepe.intent.sdk.subscriptions.network.response.DebitInitResponse;
import com.phonepe.intent.sdk.subscriptions.network.response.CreateSubscriptionResponse;
import com.phonepe.intent.sdk.subscriptions.network.response.DebitInitState;
import com.phonepe.intent.sdk.subscriptions.network.response.RedirectType;
import com.phonepe.intent.sdk.subscriptions.network.response.SubscriptionState;
import com.phonepe.intent.sdk.utils.Constants;
import com.phonepe.intent.sdk.utils.CryptLib;
import com.phonepe.intent.sdk.utils.SdkLogger;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class Subscriptions {
    public static final String TAG = "Subscriptions";
    ObjectFactory objectFactory;

    @RequiresApi(api = Build.VERSION_CODES.O)
    public void makeCreateSubscriptionCall(final Context context, final TextView subscriptionIdTextView, final Button authInit,String authWorkflowType, String amountType, String frequency, Integer amount, String subscriptionName, String merchantId, String salt, int saltIndex, String randomString, Integer recurringCount) {
        SharedPreferences sharedPref = context.getSharedPreferences(
                "SUBSCRIPTIONS", Context.MODE_PRIVATE);
        final SharedPreferences.Editor editor = sharedPref.edit();
        try {
            objectFactory = PhonePe.getObjectFactory();
            CreateSubscriptionRequest request = objectFactory.get(CreateSubscriptionRequest.class);
            request.setMerchantId(merchantId);
            final String merchantSubscriptionId = UUID.randomUUID().toString().substring(0, 9);
            request.setMerchantSubscriptionId(merchantSubscriptionId);
            request.setMerchantUserId(randomString);
            request.setSubscriptionName(subscriptionName);
            request.setRecurringCount((long) recurringCount);
            request.setAuthWorkflowType(SubscriptionAuthWorkflowType.valueOf(authWorkflowType));
            request.setAmountType(SubscriptionAmountType.valueOf(amountType));
            request.setFrequency(SubscriptionFrequency.valueOf(frequency));
            Date time = new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5));
            request.setStartAt(time.getTime());
            request.setAmount((long) (amount*100));
            SDKContext sdkContext = this.objectFactory.<SDKContext>get(SDKContext.class);
            PhonePeContext phonePeContext = this.objectFactory.<PhonePeContext>get(PhonePeContext.class);
            request.setSdkContext(sdkContext);
            Boolean isInUATMode = this.objectFactory.<Boolean>get(Constants.MerchantMeta.IS_UAT);
            final String endPoint = NetworkConstants.getApiBaseUrl(isInUATMode) + NetworkConstants.APIEndPoints.API_SUBSCRIPTION_CREATE;
            final APIManager apiManager = objectFactory.<APIManager>get(APIManager.class);
            final Map<String, String> headers = objectFactory.getHashMap();
            String payload = request.toJsonString();
            String base64Payload = Base64.encodeToString(payload.getBytes("UTF-8"), Base64.NO_WRAP);
            String path = "/v3/recurring/subscription/create";
            String checksum = getCheckSum(base64Payload, path, salt);
            String sChecksumLimiter = "###";
            headers.put("X-VERIFY", checksum + sChecksumLimiter + saltIndex);
            headers.put("Content-Type","application/json");
            final JSONObject finalPayload = new JSONObject();
            finalPayload.put("request", base64Payload);
            SdkLogger.d(TAG,"SDKContext -> " + sdkContext.toJsonString() + "\n phonepeContext -> " + phonePeContext);
            SdkLogger.d(TAG, "payload  -> " + payload + "\n" + "base64Payload  -> " + finalPayload.toString() + "\n" + "X-VERIFY  -> " + checksum + sChecksumLimiter + saltIndex + "\n");
            apiManager.asyncPostRequest(endPoint, headers, finalPayload.toString(), new INetworkResponseListener() {
                @Override
                public void onSuccess(String response) {
                    CreateSubscriptionResponse createSubscriptionResponse = CreateSubscriptionResponse.fromJsonString(response, objectFactory, CreateSubscriptionResponse.class);
                    SdkLogger.d(TAG, String.format("CreateSubscriptionResponse status : {%s}", createSubscriptionResponse.getSuccess()));
                    if (Boolean.TRUE.equals(createSubscriptionResponse.getSuccess())) {
                        try {
                           if(SubscriptionState.CREATED.equals(createSubscriptionResponse.getData().getState())){
                               editor.putString("subscriptionId", createSubscriptionResponse.getData().getSubscriptionId());
                               editor.apply();
                               Toast.makeText(context,"Subscription created :)",Toast.LENGTH_SHORT).show();
                               subscriptionIdTextView.setText(createSubscriptionResponse.getData().getSubscriptionId());
                               subscriptionIdTextView.setTextColor(context.getResources().getColor(R.color.colorBrandPrimary));
                               authInit.setEnabled(true);
                           }
                        } catch (PhonePeInitException e) {
                            e.printStackTrace();
                        }
                    } else {
                        Toast.makeText(context,"Subscription failed :( Please try again!",Toast.LENGTH_SHORT).show();
                    }
                }

                @Override
                public void onFailure(int responseCode, String response) {
                    SdkLogger.e(TAG, String.format("CreateSubscriptionResponse ,responseCode = {%d}, response = {%s}", responseCode, response));
                    Toast.makeText(context,"Subscription failed :( Please try again!",Toast.LENGTH_SHORT).show();
                }
            }, false);
        } catch (UnsupportedEncodingException | PhonePeInitException | JSONException e) {
            SdkLogger.e(TAG, "exception");
            e.printStackTrace();
        }
    }

    public void authInitCall(final Context context, String subscriptionId, Integer amount, String merchantId, String salt, int saltIndex, String randomString, final Button startDebitInit) {
        try {
            objectFactory = PhonePe.getObjectFactory();
            AuthInitRequest request = objectFactory.get(AuthInitRequest.class);
            request.setMerchantId(merchantId);
            request.setMerchantUserId(randomString);
            final String authRequestId = UUID.randomUUID().toString().substring(0, 9);
            request.setAuthRequestId(authRequestId);
            request.setSubscriptionId(subscriptionId);
            request.setAmount((long) (amount*100));
            final Boolean isInUATMode = this.objectFactory.<Boolean>get(Constants.MerchantMeta.IS_UAT);
            final String endPoint = NetworkConstants.getApiBaseUrl(isInUATMode) + NetworkConstants.APIEndPoints.API_SUBSCRIPTION_AUTH_INIT;
            final APIManager apiManager = objectFactory.<APIManager>get(APIManager.class);
            final Map<String, String> headers = objectFactory.getHashMap();
            String payload = request.toJsonString();
            String base64Payload = Base64.encodeToString(payload.getBytes("UTF-8"), Base64.NO_WRAP);
            String path = "/v3/recurring/auth/init";
            String checksum = getCheckSum(base64Payload, path, salt);
            String sChecksumLimiter = "###";
            headers.put("X-VERIFY", checksum + sChecksumLimiter + saltIndex);
            headers.put("Content-Type","application/json");
            headers.put("x_callback_url", "https://webhook.site/88a5ceaf-80bd-45c4-b2dc-b7d008d26a12");
            final JSONObject finalPayload = new JSONObject();
            finalPayload.put("request", base64Payload);
            SdkLogger.d(TAG, "payload  -> " + payload + "\n" + "base64Payload  -> " + finalPayload.toString() + "\n" + "X-VERIFY  -> " + checksum + sChecksumLimiter + saltIndex + "\n");
            apiManager.asyncPostRequest(endPoint, headers, finalPayload.toString(), new INetworkResponseListener() {
                @Override
                public void onSuccess(String response) {
                    AuthInitResponse authInitResponse = AuthInitResponse.fromJsonString(response, objectFactory, AuthInitResponse.class);
                    SdkLogger.d(TAG, String.format("AuthInitResponse status : {%s}", authInitResponse.getSuccess()));
                    if(Boolean.TRUE.equals(authInitResponse.getSuccess())){
                        try {
                            if(authInitResponse.getData().getRedirectType() == RedirectType.INTENT){
                                Toast.makeText(context,"AuthInit success :)",Toast.LENGTH_SHORT).show();
                                Log.d(TAG, authInitResponse.getData().getRedirectUrl());
                                String PP_APP_PACKAGE = BuildConfig.BUILD_TYPE.equals("uat") ? "com.phonepe.app.preprod" : "com.phonepe.app.debug";
                                Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(authInitResponse.getData().getRedirectUrl()));
                                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
                                intent.setPackage(PP_APP_PACKAGE);
                                context.startActivity(intent);
                                startDebitInit.setEnabled(true);
                            }
                        } catch (PhonePeInitException e) {
                            e.printStackTrace();
                        }
                    } else {
                        Toast.makeText(context,"AuthInit failed :( Please try again!",Toast.LENGTH_SHORT).show();
                    }
                }

                @Override
                public void onFailure(int responseCode, String response) {
                    SdkLogger.e(TAG, String.format("AuthInitResponse ,responseCode = {%d}, response = {%s}", responseCode, response));
                    Toast.makeText(context,"Auth Init failed :( Please try again!",Toast.LENGTH_SHORT).show();
                }
            }, false);
        } catch (UnsupportedEncodingException | PhonePeInitException | JSONException e) {
            SdkLogger.e(TAG, "AuthInitResponse exception");
            e.printStackTrace();
        }
    }

    public void debitInitCall(final Context context, String subscriptionId, Integer amount, String merchantId, String salt, int saltIndex, String randomString) {
        try {
            objectFactory = PhonePe.getObjectFactory();
            DebitInitRequest request = objectFactory.get(DebitInitRequest.class);
            request.setMerchantId(merchantId);
            request.setMerchantUserId(randomString);
            request.setAutoDebit(true);
            request.setSubscriptionId(subscriptionId);
            final String txnId = UUID.randomUUID().toString().substring(0, 9);
            request.setTransactionId(txnId);
            request.setAmount((long) (amount*100));
            final Boolean isInUATMode = this.objectFactory.<Boolean>get(Constants.MerchantMeta.IS_UAT);
            final String endPoint = NetworkConstants.getApiBaseUrl(isInUATMode) + NetworkConstants.APIEndPoints.API_SUBSCRIPTION_DEBIT_INIT;
            final APIManager apiManager = objectFactory.<APIManager>get(APIManager.class);
            final Map<String, String> headers = objectFactory.getHashMap();
            String payload = request.toJsonString();
            String base64Payload = Base64.encodeToString(payload.getBytes("UTF-8"), Base64.NO_WRAP);
            String path = "/v3/recurring/debit/init";
            String checksum = getCheckSum(base64Payload, path, salt);
            String sChecksumLimiter = "###";
            headers.put("X-VERIFY", checksum + sChecksumLimiter + saltIndex);
            headers.put("x_callback_url", "https://webhook.site/c447c4b6-c256-4e11-877d-83408beefddf");
            headers.put("x-call-mode","POST");
            headers.put("Content-Type","application/json");
            final JSONObject finalPayload = new JSONObject();
            finalPayload.put("request", base64Payload);
            SdkLogger.d(TAG, "payload  -> " + payload + "\n" + "base64Payload  -> " + finalPayload.toString() + "\n" + "X-VERIFY  -> " + checksum + sChecksumLimiter + saltIndex + "\n");
            apiManager.asyncPostRequest(endPoint, headers, finalPayload.toString(), new INetworkResponseListener() {
                @Override
                public void onSuccess(String response) {
                    DebitInitResponse debitInitResponse = DebitInitResponse.fromJsonString(response, objectFactory, DebitInitResponse.class);
                    SdkLogger.d(TAG, String.format("DebitInitResponse status : {%s}", debitInitResponse.getSuccess()));
                    if(Boolean.TRUE.equals(debitInitResponse.getSuccess())) {
                        try {
                            if(debitInitResponse.getData().getState() == DebitInitState.ACCEPTED){
                                Toast.makeText(context,"Debit Init success :)",Toast.LENGTH_SHORT).show();
                            }
                        } catch (PhonePeInitException e) {
                            e.printStackTrace();
                        }
                    } else {
                        Toast.makeText(context,"DebitInitResponse failed :( Please try again!",Toast.LENGTH_SHORT).show();
                    }
                }

                @Override
                public void onFailure(int responseCode, String response) {
                    SdkLogger.e(TAG, String.format("DebitInitResponse ,responseCode = {%d}, response = {%s}", responseCode, response));
                    Toast.makeText(context,"DebitInitResponse failed :( Please try again!",Toast.LENGTH_SHORT).show();
                }
            }, false);
        } catch (UnsupportedEncodingException | PhonePeInitException | JSONException e) {
            SdkLogger.e(TAG, "DebitInitResponse exception");
            e.printStackTrace();
        }
    }

    private String getCheckSum(String body, String endPoint, String salt) {
        try {
            CryptLib cryptLib = new CryptLib();
            byte[] hash = cryptLib.SHA256(body + endPoint + salt);
            StringBuffer hashtext = new StringBuffer();

            for (int i = 0; i < hash.length; i++) {
                String hex = Integer.toHexString(0xff & hash[i]);
                if (hex.length() == 1) hashtext.append('0');
                hashtext.append(hex);
            }
            // Uncomment this when you want to debug Checksum logic
            SdkLogger.d(TAG, "Body: "+body+"\nEndPoint: "+endPoint+"\nSalt: "+salt+"\nHashText:"+hashtext);
            return hashtext.toString();
        } catch (Exception e) {
            SdkLogger.e(TAG, e.getMessage(), e);
            return null;
        }
    }

    public void testOpen(Context context) {
        String PP_APP_PACKAGE_STAGE = "com.phonepe.app.debug";
        String uri = "upi://pay?pn=SUBSCRIBEMID&pa=MID12345@ybl&tid=YBL6663638d0312408a8f54f7df8f1bd6b9&tr=P1812191027266848105909&am=399.00&mam=399.00&cu=INR&url=https://phonepe.com&mc=7299&tn=Payment%20for%20TXN123456789&utm_source=TXN123456789&utm_medium=MID12345&utm_campaign=SUBSCRIBE_AUTH";
        Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(uri));
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        intent.setPackage(PP_APP_PACKAGE_STAGE);
        context.startActivity(intent);
    }
}
