package com.phonepe.intent.sdk.subscriptions.network.request;

import android.support.annotation.NonNull;
import com.phonepe.intent.sdk.models.DefaultJsonImpl;
import com.phonepe.intent.sdk.models.SDKContext;

public class CreateSubscriptionRequest extends DefaultJsonImpl {

    private static final String KEY_MERCHANT_ID = "merchantId";
    private static final String KEY_MERCHANT_SUBSCRIPTION_ID = "merchantSubscriptionId";
    private static final String KEY_MERCHANT_USER_ID = "merchantUserId";
    private static final String KEY_SUBSCRIPTION_NAME = "subscriptionName";
    private static final String KEY_AUTH_WORKFLOW_TYPE = "authWorkflowType";
    private static final String KEY_AMOUNT_TYPE = "amountType";
    private static final String KEY_AMOUNT = "amount";
    private static final String KEY_FREQUENCY = "frequency";
    private static final String KEY_RECURRING_COUNT = "recurringCount";
    private static final String KEY_START_AT = "startAt";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_MOBILE_NUMBER = "mobileNumber";
    private static final String KEY_SUB_MERCHANT = "subMerchant";
    private static final String KEY_SDK_CONTEXT = "sdkContext";

    public void setMerchantId(@NonNull String merchantId) {
        put(KEY_MERCHANT_ID, merchantId);
    }

    public void setMerchantSubscriptionId(@NonNull String merchantSubscriptionId) {
        put(KEY_MERCHANT_SUBSCRIPTION_ID, merchantSubscriptionId);
    }

    public void setMerchantUserId(@NonNull String merchantUserId) {
        put(KEY_MERCHANT_USER_ID, merchantUserId);
    }

    public void setSubscriptionName(String subscriptionName) {
        put(KEY_SUBSCRIPTION_NAME, subscriptionName);
    }
    public void setAuthWorkflowType(@NonNull SubscriptionAuthWorkflowType authWorkflowType) {
        put(KEY_AUTH_WORKFLOW_TYPE,authWorkflowType.name());
    }

    public void setAmountType(@NonNull SubscriptionAmountType amountType) {
        put(KEY_AMOUNT_TYPE,amountType.name());
    }

    public void setAmount(@NonNull Long amount) {
        put(KEY_AMOUNT,amount);
    }

    public void setFrequency(@NonNull SubscriptionFrequency frequency) {
        put(KEY_FREQUENCY, frequency.name());
    }

    public void setRecurringCount(@NonNull Long recurringCount) {
        put(KEY_RECURRING_COUNT,recurringCount);
    }

    //todo:change to long
    public void setStartAt(long startAt) {
        put(KEY_START_AT,startAt);
    }
    public void setDescription(String description) {
        put(KEY_DESCRIPTION, description);
    }

    public void setMobileNumber(String mobileNumber) {
        put(KEY_MOBILE_NUMBER,mobileNumber);
    }

    public void setSubMerchant(String subMerchant) {
        put(KEY_SUB_MERCHANT, subMerchant);
    }

    //todo: change to data & sdkcontext request
    public void setSdkContext(SDKContext sdkContext) {
        if (sdkContext != null) {
            put(KEY_SDK_CONTEXT, sdkContext.toJsonObject());
        }
    }

}