package com.phonepe.intent.sdk.subscriptions.network.request;

import android.support.annotation.NonNull;

import com.phonepe.intent.sdk.models.DefaultJsonImpl;

public class DebitInitRequest extends DefaultJsonImpl {

    private static final String KEY_MERCHANT_ID = "merchantId";
    private static final String KEY_SUBSCRIPTION_ID = "subscriptionId";
    private static final String KEY_MERCHANT_USER_ID = "merchantUserId";
    private static final String KEY_TXN_ID = "transactionId";
    private static final String KEY_AUTO_DEBIT = "autoDebit";
    private static final String KEY_AMOUNT = "amount";

    public void setMerchantId(@NonNull String merchantId) {
        put(KEY_MERCHANT_ID, merchantId);
    }

    public void setMerchantUserId(@NonNull String merchantUserId) {
        put(KEY_MERCHANT_USER_ID, merchantUserId);
    }

    public void setSubscriptionId(@NonNull String subscriptionId) {
        put(KEY_SUBSCRIPTION_ID, subscriptionId);
    }

    public void setAutoDebit(boolean autoDebit) {
        put(KEY_AUTO_DEBIT, autoDebit);
    }

    public void setTransactionId(String authRequestId) {
        put(KEY_TXN_ID, authRequestId);
    }

    public void setAmount(@NonNull Long amount) {
        put(KEY_AMOUNT,amount);
    }

}