package com.phonepe.intent.sdk.subscriptions.network.response;

import android.support.annotation.NonNull;

import com.phonepe.intent.sdk.api.PhonePe;
import com.phonepe.intent.sdk.api.PhonePeInitException;
import com.phonepe.intent.sdk.models.DefaultJsonImpl;

import org.json.JSONObject;

public class CreateSubscriptionResponse extends DefaultJsonImpl {

    private static final String KEY_SUCCESS = "success";
    private static final String KEY_CODE = "code";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_DATA = "data";

    public Boolean getSuccess() {
        return get(KEY_SUCCESS);
    }

    public void setSuccess(@NonNull Boolean success) {
        put(KEY_SUCCESS, success);
    }

    public String getCode() {
        return get(KEY_CODE);
    }

    public void setCode(@NonNull String code) {
        put(KEY_CODE, code);
    }

    public String getMessage() {
        return get(KEY_MESSAGE);
    }

    public void setMessage(String message) {
        put(KEY_MESSAGE, message);
    }

    // TODO: find a better way of doing this
    public CreateSubscriptionResponseData getData() throws PhonePeInitException {
        return fromJsonString(get(KEY_DATA).toString(), PhonePe.getObjectFactory(), CreateSubscriptionResponseData.class);
    }

    public void setData(@NonNull JSONObject data){
        put(KEY_DATA, data);
    }

    public static class CreateSubscriptionResponseData extends DefaultJsonImpl{
        private static final String KEY_SUBSCRIPTION_ID = "subscriptionId";
        private static final String KEY_STATE = "state";
        private static final String KEY_VALID_UPTO = "validUpto";

        public String getSubscriptionId() {
            return get(KEY_SUBSCRIPTION_ID);
        }

        public void setSubscriptionId(@NonNull String subscriptionId) {
            put(KEY_SUBSCRIPTION_ID, subscriptionId);
        }
        public SubscriptionState getState() {
            return SubscriptionState.valueOf(get(KEY_STATE).toString());
        }

        public void setState(@NonNull String state) {
            put(KEY_STATE, state);
        }

        public Long getValidUpto() {
            return get(KEY_VALID_UPTO);
        }

        public void setValidUpto(Long validUpto) {
            put(KEY_VALID_UPTO, validUpto);
        }

    }

}
