package com.phonepe.intent.sdk.subscriptions.network.response;

import android.support.annotation.NonNull;

import com.phonepe.intent.sdk.api.PhonePe;
import com.phonepe.intent.sdk.api.PhonePeInitException;
import com.phonepe.intent.sdk.models.DefaultJsonImpl;

import org.json.JSONObject;
public class DebitInitResponse extends DefaultJsonImpl {
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_CODE = "code";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_DATA = "data";
    public Boolean getSuccess() {
        return get(KEY_SUCCESS);
    }
    public void setSuccess(@NonNull Boolean success) {
        put(KEY_SUCCESS, success);
    }
    public String getCode() {
        return get(KEY_CODE);
    }
    public void setCode(@NonNull String code) {
        put(KEY_CODE, code);
    }
    public String getMessage() {
        return get(KEY_MESSAGE);
    }
    public void setMessage(String message) {
        put(KEY_MESSAGE, message);
    }
    // TODO: find a better way of doing this
    public DebitInitResponseData getData() throws PhonePeInitException {
        return fromJsonString(get(KEY_DATA).toString(), PhonePe.getObjectFactory(), DebitInitResponseData.class);
    }
    public void setData(@NonNull JSONObject data){
        put(KEY_DATA, data);
    }

    public static class DebitInitResponseData extends DefaultJsonImpl {
        private static final String KEY_NOTIFICATION_ID = "notificationId";
        private static final String KEY_STATE = "state";
        private static final String KEY_AMOUNT = "amount";

        public String getNotificationId() {
            return get(KEY_NOTIFICATION_ID);
        }

        public void setNotificationId(@NonNull String subscriptionId) {
            put(KEY_NOTIFICATION_ID, subscriptionId);
        }

        public DebitInitState getState() {
            return DebitInitState.valueOf(get(KEY_STATE).toString());
        }

        public void setState(@NonNull String state) {
            put(KEY_STATE, state);
        }

        public void getAmount() {
            get(KEY_AMOUNT);
        }

        public void setAmount(@NonNull Long amount) {
            put(KEY_AMOUNT, amount);
        }

    }
}