package com.phonepe.intent.sdk.utils;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;

import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.core.ObjectFactoryInitializationStrategy;
import com.phonepe.intent.sdk.models.MyLocation;

/**
 * Date 22/06/17
 *
 * @author Ankit Jain
 */

public class LocationProvider implements LocationListener, ObjectFactoryInitializationStrategy {

    private static final String TAG = "LocationProvider";
    //The minimum distance to change Updates in meters
    private static final long MIN_DISTANCE_CHANGE_FOR_UPDATES = 1000 * 50; //50 Km
    //The minimum time between updates in milliseconds
    private static final long MIN_TIME_BW_UPDATES = 1000 * 60 * 60 * 24 * 3; //30 days
    private Context context;
    private Location location = null;
    private ObjectFactory objectFactory;

    public MyLocation getLastKnownLocation(Context context) {

        try {

            LocationManager locationManager = (LocationManager) context.getSystemService(Context.LOCATION_SERVICE);

            if (locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER)) {
                location = locationManager.getLastKnownLocation(LocationManager.GPS_PROVIDER);
            }

            if (location == null && locationManager.isProviderEnabled(LocationManager.PASSIVE_PROVIDER)) {
                location = locationManager.getLastKnownLocation(LocationManager.PASSIVE_PROVIDER);
            }

            if (location == null && locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)) {
                location = locationManager.getLastKnownLocation(LocationManager.NETWORK_PROVIDER);
            }


            if (location == null && locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER)) {
                locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, MIN_TIME_BW_UPDATES, MIN_DISTANCE_CHANGE_FOR_UPDATES, this, Looper.getMainLooper());
                location = locationManager.getLastKnownLocation(LocationManager.GPS_PROVIDER);
            }


            if (location == null && locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)) {
                locationManager.requestLocationUpdates(LocationManager.NETWORK_PROVIDER, MIN_TIME_BW_UPDATES, MIN_DISTANCE_CHANGE_FOR_UPDATES, this, Looper.getMainLooper());
                location = locationManager.getLastKnownLocation(LocationManager.NETWORK_PROVIDER);
            }


            if (location != null) {
                MyLocation myLocation = this.objectFactory.<MyLocation>get(MyLocation.class);
                myLocation.setLatitude(location.getLatitude());
                myLocation.setLongitude(location.getLongitude());
                return myLocation;
            }

        } catch (Exception e) {
            SdkLogger.e(TAG, e.getMessage(), e);
        }

        //If location is not found
        return null;
    }


    @Override
    public void onLocationChanged(Location location) {
        this.location = location;
    }

    @Override
    public void onProviderDisabled(String provider) {
    }

    @Override
    public void onProviderEnabled(String provider) {
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    @Override
    public void init(ObjectFactory objectFactory, ObjectFactory.InitializationBundle initializationBundle) {

        this.objectFactory = objectFactory;
    }

    @Override
    public boolean isCachingAllowed() {
        return true;
    }
}
