package com.phonepe.intent.sdk.utils;

import com.phonepe.intent.sdk.BuildConfig;
import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.core.ObjectFactoryInitializationStrategy;
import com.phonepe.intent.sdk.models.Event;

import static com.phonepe.intent.sdk.utils.AnalyticsManager.EventConstants.ERROR_MESSAGE;
import static com.phonepe.intent.sdk.utils.AnalyticsManager.Events.SDK_RUNTIME_ERROR;

public class RuntimeExceptionManager implements ObjectFactoryInitializationStrategy {

    public enum Severity {
        HIGH,
        LOW
    }

    private ObjectFactory objectFactory;
    private AnalyticsManager analyticsManager;

    @Override
    public void init(ObjectFactory objectFactory, ObjectFactory.InitializationBundle initializationBundle) {
        this.objectFactory = objectFactory;
        this.analyticsManager = objectFactory.<AnalyticsManager>get(AnalyticsManager.class);
    }

    @Override
    public boolean isCachingAllowed() {
        return true;
    }

    public void submit(String tag, String message, Severity severity) {

        SdkLogger.e(tag, message);
        if (BuildConfig.DEBUG || Severity.HIGH.equals(severity)) {

            sendRuntimeError(String.format("tag = {%s}, errorMessage = {%s}", tag, message));
            throw new RuntimeException(message);
        }
    }

    private void sendRuntimeError(String errorMessage) {

        Event event = analyticsManager.getEvent(SDK_RUNTIME_ERROR).putInEventBody(ERROR_MESSAGE, errorMessage);
        analyticsManager.submit(event);
    }
}
