package com.phonepe.intent.sdk.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.util.Log;

import com.phonepe.intent.sdk.BuildConfig;
import com.phonepe.intent.sdk.api.PhonePe;
import com.phonepe.intent.sdk.core.DataConfig;
import com.phonepe.intent.sdk.core.ObjectFactoryInitializationStrategy;
import com.phonepe.intent.sdk.models.SDKConfig;
import com.phonepe.intent.sdk.networking.APIHelper;
import com.phonepe.intent.sdk.networking.models.DeviceEventPayload;

public class SdkLogger {

    private static ILoggerStrategy loggerStrategy;

    public static void init(@NonNull Context context) {
        if (! Constants.GenericConstants.RELEASE.equalsIgnoreCase(BuildConfig.BUILD_TYPE) ) {
            loggerStrategy = new Debug();
            return;
        }

        loggerStrategy = new Release();
    }

    public static void d(String tag, String message) {
        if(loggerStrategy != null)
        loggerStrategy.d(tag, message);
    }

    public static void e(String tag, String message) {
        if(loggerStrategy != null)
        loggerStrategy.e(tag, message);
    }

    public static void v(String tag, String message) {
        if(loggerStrategy != null)
        loggerStrategy.v(tag, message);
    }

    public static void wtf(String tag, String message) {
        if(loggerStrategy != null)
        loggerStrategy.wtf(tag, message);
    }

    public static void w(String tag, String message) {
        if(loggerStrategy != null)
        loggerStrategy.w(tag, message);
    }

    public static void i(String tag, String message) {
        if(loggerStrategy != null)
        loggerStrategy.i(tag, message);
    }

    public static void d(String tag, String message, Exception e) {
        if(loggerStrategy != null)
        loggerStrategy.d(tag, message, e);
    }

    public static void e(String tag, String message, Exception e) {
        if(loggerStrategy != null)
        loggerStrategy.e(tag, message, e);
    }

    public static void v(String tag, String message, Exception e) {
        if(loggerStrategy != null)
        loggerStrategy.v(tag, message, e);
    }

    public static void wtf(String tag, String message, Exception e) {
        if(loggerStrategy != null)
        loggerStrategy.wtf(tag, message, e);
    }

    public static void w(String tag, String message, Exception e) {
        if(loggerStrategy != null)
        loggerStrategy.w(tag, message, e);
    }

    public static void i(String tag, String message, Exception e) {
        if(loggerStrategy != null)
        loggerStrategy.i(tag, message, e);
    }

    public static void webD(String tag, String message, int lineNumber, String sourceId) {
        if(loggerStrategy != null)
        loggerStrategy.webD(tag, message, lineNumber, sourceId);
    }

    public static void webW(String tag, String message, int lineNumber, String sourceId) {
        if(loggerStrategy != null)
        loggerStrategy.webW(tag, message, lineNumber, sourceId);
    }

    public static void webL(String tag, String message, int lineNumber, String sourceId) {
        if(loggerStrategy != null)
        loggerStrategy.webL(tag, message, lineNumber, sourceId);
    }

    public static void webE(String tag, String message, int lineNumber, String sourceId) {
        if(loggerStrategy != null)
        loggerStrategy.webE(tag, message, lineNumber, sourceId);
    }

    public static void webT(String tag, String message, int lineNumber, String sourceId) {
        if(loggerStrategy != null)
        loggerStrategy.webT(tag, message, lineNumber, sourceId);
    }


    private interface ILoggerStrategy {

        void d(String tag, String message);

        void e(String tag, String message);

        void v(String tag, String message);

        void wtf(String tag, String message);

        void w(String tag, String message);

        void i(String tag, String message);

        void d(String tag, String message, Exception e);

        void e(String tag, String message, Exception e);

        void v(String tag, String message, Exception e);

        void wtf(String tag, String message, Exception e);

        void w(String tag, String message, Exception e);

        void i(String tag, String message, Exception e);

        void webD(String tag, String message, int lineNumber, String sourceId);

        void webW(String tag, String message, int lineNumber, String sourceId);

        void webL(String tag, String message, int lineNumber, String sourceId);

        void webE(String tag, String message, int lineNumber, String sourceId);

        void webT(String tag, String message, int lineNumber, String sourceId);

    }

    private static class Debug extends LoggerStrategy {
        @Override
        public void v(String tag, String message) {
            super.v(tag, message);
            Log.v(tag, message);
        }

        @Override
        public void v(String tag, String message, Exception e) {
            super.v(tag, message, e);
            Log.v(tag, message, e);
        }

        @Override
        public void d(String tag, String message) {
            super.d(tag, message);
            Log.d(tag, message);
        }

        @Override
        public void d(String tag, String message, Exception e) {
            super.d(tag, message, e);
            Log.d(tag, message, e);
        }

        @Override
        public void i(String tag, String message) {
            super.i(tag, message);
            Log.i(tag, message);
        }

        @Override
        public void i(String tag, String message, Exception e) {
            super.i(tag, message, e);
            Log.i(tag, message, e);
        }

        @Override
        public void w(String tag, String message) {
            super.w(tag, message);
            Log.w(tag, message);
        }

        @Override
        public void w(String tag, String message, Exception e) {
            super.w(tag, message, e);
            Log.w(tag, message, e);
        }

        @Override
        public void e(String tag, String message) {
            super.e(tag, message);
            Log.e(tag, message);
        }

        @Override
        public void e(String tag, String message, Exception e) {
            super.e(tag, message, e);
            Log.e(tag, message, e);
        }

        @Override
        public void wtf(String tag, String message) {
            super.wtf(tag, message);
            Log.wtf(tag, message);
        }

        @Override
        public void wtf(String tag, String message, Exception e) {
            super.wtf(tag, message, e);
            Log.wtf(tag, message, e);
        }

        @Override
        public void webD(String tag, String message, int lineNumber, String sourceId) {
            super.webD(tag, message, lineNumber, sourceId);
            Log.d(tag, "Message: " + message + "\nLine Number: " + lineNumber + "\nSourceId: " + sourceId);
        }

        @Override
        public void webW(String tag, String message, int lineNumber, String sourceId) {
            super.webW(tag, message, lineNumber, sourceId);
            Log.w(tag, "Message: " + message + "\nLine Number: " + lineNumber + "\nSourceId: " + sourceId);
        }

        @Override
        public void webL(String tag, String message, int lineNumber, String sourceId) {
            super.webL(tag, message, lineNumber, sourceId);
            Log.i(tag, "Message: " + message + "\nLine Number: " + lineNumber + "\nSourceId: " + sourceId);
        }

        @Override
        public void webE(String tag, String message, int lineNumber, String sourceId) {
            super.webE(tag, message, lineNumber, sourceId);
            Log.e(tag, "Message: " + message + "\nLine Number: " + lineNumber + "\nSourceId: " + sourceId);
        }

        @Override
        public void webT(String tag, String message, int lineNumber, String sourceId) {
            super.webT(tag, message, lineNumber, sourceId);
            Log.i(tag, "Message: " + message + "\nLine Number: " + lineNumber + "\nSourceId: " + sourceId);
        }
    }

    private static class Release extends LoggerStrategy {


    }

    private static class LoggerStrategy implements ILoggerStrategy {
        SDKConfig sdkConfig;

        private boolean canLog(int logLevel) {
            try {
                if (PhonePe.getObjectFactory() != null) {
                    sdkConfig = PhonePe.getObjectFactory().get(SDKConfig.class);
                    return sdkConfig.isAndroidLogsEnabled() && sdkConfig.getAndroidLogsLevel() <= logLevel;
                }
            } catch (Exception e) {
                return false;
            }
            return false;
        }

        private boolean canWebLog(int logLevel) {
            try {
                if (PhonePe.getObjectFactory() != null) {
                    sdkConfig = PhonePe.getObjectFactory().get(SDKConfig.class);
                    return sdkConfig.isWebLogsEnabled() && sdkConfig.getWebLogsLevel() <= logLevel;
                }
            } catch (Exception e) {
                return false;
            }
            return false;
        }

        @Override
        public void d(String tag, String message) {
            if (canLog(SDKConfig.LOG_LEVEL_DEBUG)) {
                Log.d(tag, message);
            }
        }

        @Override
        public void e(String tag, String message) {
            if (canLog(SDKConfig.LOG_LEVEL_ERROR)) {
                Log.e(tag, message);
            }
        }

        @Override
        public void v(String tag, String message) {
            if (canLog(SDKConfig.LOG_LEVEL_DEBUG)) {
                Log.v(tag, message);
            }
        }

        @Override
        public void wtf(String tag, String message) {
            if (canLog(SDKConfig.LOG_LEVEL_ERROR)) {
                Log.wtf(tag, message);
            }
        }

        @Override
        public void w(String tag, String message) {
            if (canLog(SDKConfig.LOG_LEVEL_WARN)) {
                Log.w(tag, message);
            }
        }

        @Override
        public void i(String tag, String message) {
            if (canLog(SDKConfig.LOG_LEVEL_INFO)) {
                Log.i(tag, message);
            }
        }

        @Override
        public void d(String tag, String message, Exception e) {
            if (canLog(SDKConfig.LOG_LEVEL_DEBUG)) {
                Log.d(tag, message, e);
            }
        }

        @Override
        public void e(String tag, String message, Exception e) {
            if (canLog(SDKConfig.LOG_LEVEL_ERROR)) {
                Log.e(tag, message, e);
            }
        }

        @Override
        public void v(String tag, String message, Exception e) {
            if (canLog(SDKConfig.LOG_LEVEL_DEBUG)) {
                Log.v(tag, message, e);
            }
        }

        @Override
        public void wtf(String tag, String message, Exception e) {
            if (canLog(SDKConfig.LOG_LEVEL_ERROR)) {
                Log.wtf(tag, message, e);
            }
        }

        @Override
        public void w(String tag, String message, Exception e) {
            if (canLog(SDKConfig.LOG_LEVEL_WARN)) {
                Log.w(tag, message, e);
            }
        }

        @Override
        public void i(String tag, String message, Exception e) {
            if (canLog(SDKConfig.LOG_LEVEL_INFO)) {
                Log.i(tag, message, e);
            }
        }

        @Override
        public void webD(String tag, String message, int lineNumber, String sourceId) {
            if (canWebLog(SDKConfig.LOG_LEVEL_DEBUG)) {
                Log.d(tag, "Message: " + message + "\nLine Number: " + lineNumber + "\nSourceId: " + sourceId);
            }
        }

        @Override
        public void webW(String tag, String message, int lineNumber, String sourceId) {
            if (canWebLog(SDKConfig.LOG_LEVEL_WARN)) {
                Log.w(tag, "Message: " + message + "\nLine Number: " + lineNumber + "\nSourceId: " + sourceId);
            }
        }

        @Override
        public void webL(String tag, String message, int lineNumber, String sourceId) {
            if (canWebLog(SDKConfig.LOG_LEVEL_INFO)) {
                Log.i(tag, "Message: " + message + "\nLine Number: " + lineNumber + "\nSourceId: " + sourceId);
            }
        }

        @Override
        public void webE(String tag, String message, int lineNumber, String sourceId) {
            if (canWebLog(SDKConfig.LOG_LEVEL_ERROR)) {
                Log.e(tag, "Message: " + message + "\nLine Number: " + lineNumber + "\nSourceId: " + sourceId);
            }
        }

        @Override
        public void webT(String tag, String message, int lineNumber, String sourceId) {
            if (canWebLog(SDKConfig.LOG_LEVEL_INFO)) {
                Log.i(tag, "Message: " + message + "\nLine Number: " + lineNumber + "\nSourceId: " + sourceId);
            }
        }
    }

}
