package com.phonepe.intent.sdk.wallettopup.network.response;

import android.support.annotation.NonNull;

import com.phonepe.intent.sdk.api.PhonePe;
import com.phonepe.intent.sdk.api.PhonePeInitException;
import com.phonepe.intent.sdk.models.DefaultJsonImpl;
import com.phonepe.intent.sdk.wallettopup.network.request.ResponseType;

import org.json.JSONObject;

public class WalletTopUpResponse extends DefaultJsonImpl {

    private static final String KEY_SUCCESS = "success";
    private static final String KEY_CODE = "code";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_DATA = "data";

    public Boolean getSuccess() {
        return get(KEY_SUCCESS);
    }

    public void setSuccess(@NonNull Boolean success) {
        put(KEY_SUCCESS, success);
    }

    public String getCode() {
        return get(KEY_CODE);
    }

    public void setCode(@NonNull String code) {
        put(KEY_CODE, code);
    }

    public String getMessage() {
        return get(KEY_MESSAGE);
    }

    public void setMessage(String message) {
        put(KEY_MESSAGE, message);
    }

    // TODO: find a better way of doing this
    public WalletTopUpResponseData getData() throws PhonePeInitException {
        return fromJsonString(get(KEY_DATA).toString(), PhonePe.getObjectFactory(), WalletTopUpResponseData.class);
    }

    public void setData(@NonNull JSONObject data){
        put(KEY_DATA, data);
    }

    public static class WalletTopUpResponseData extends DefaultJsonImpl{
        private static final String KEY_RESPONSE_TYPE = "responseType";
        private static final String KEY_REDIRECT_URL = "redirectUrl";

        public ResponseType getResponseType() {
            return ResponseType.valueOf(get(KEY_RESPONSE_TYPE).toString());
        }

        public void setResponseType(String responseType) {
            put(KEY_RESPONSE_TYPE, responseType);
        }

        public String getRedirectUrl() {
            return get(KEY_REDIRECT_URL);
        }

        public void setRedirectUrl(@NonNull String redirectUrl) {
            put(KEY_REDIRECT_URL, redirectUrl);
        }

    }

}
