package com.phonepe.intent.sdk.wallettopup.ui;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.phonepe.intent.sdk.R;
import com.phonepe.intent.sdk.api.PhonePe;
import com.phonepe.intent.sdk.api.PhonePeInitException;
import com.phonepe.intent.sdk.api.RequestCallback;
import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.models.SDKContext;
import com.phonepe.intent.sdk.networking.APIHelper;
import com.phonepe.intent.sdk.networking.APIManager;
import com.phonepe.intent.sdk.networking.INetworkResponseListener;
import com.phonepe.intent.sdk.networking.NetworkConstants;
import com.phonepe.intent.sdk.utils.Constants;
import com.phonepe.intent.sdk.utils.CryptLib;
import com.phonepe.intent.sdk.utils.SdkLogger;
import com.phonepe.intent.sdk.wallettopup.network.request.ResponseType;
import com.phonepe.intent.sdk.wallettopup.network.request.WalletBalanceRequest;
import com.phonepe.intent.sdk.wallettopup.network.request.WalletTopUpRequest;
import com.phonepe.intent.sdk.wallettopup.network.response.DebitSuggestCallback;
import com.phonepe.intent.sdk.wallettopup.network.response.WalletBalanceResponse;
import com.phonepe.intent.sdk.wallettopup.network.response.WalletTopUpResponse;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.util.Map;

public class WalletTopUpActivity extends Activity {
    public static final String TAG = "WalletTopUpActivity";
    public static final int PHONEPE_WALLET_TOPUP_REQUEST_CODE = 9002;
    ObjectFactory objectFactory;
    Button shouldShowWalletTopup, startTopup;
    EditText amount, userAuthToken;
    TextView apiResponse, responseTv, dlApiRsponse;
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_wallet);
        setDefaultState();
    }

    private void setDefaultState() {
        shouldShowWalletTopup = findViewById(R.id.btn_should_show_wallet_topup);
        startTopup = findViewById(R.id.btn_deeplink_generate_topup);
        amount = findViewById(R.id.wallet_topup_txn_amount);
        userAuthToken = findViewById(R.id.wallet_user_auth_token);
        responseTv = findViewById(R.id.tv_response);
        apiResponse = findViewById(R.id.tv_api_response);
        dlApiRsponse = findViewById(R.id.dl_api_response);
        startTopup.setEnabled(false);
        shouldShowWalletTopup.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //merchant will do this
                int keyIndex = 1;
                String merchantId = "DREAM11ONLINE";
                String uAuthToken = userAuthToken.getText().toString();
                Long amnt = Long.parseLong(amount.getText().toString()) * 100;
                if(amnt <= 0) {
                    Toast.makeText(getApplicationContext(), "Invalid amount", Toast.LENGTH_SHORT).show();
                    return;
                }
                String key = "6ab539dc-6ace-48c5-b957-75cb408e4f29";
                String path = "/v3/wallet/balance";
                JSONObject data = new JSONObject();
                try {
                    data.put("txnAmount",amnt);
                    data.put("merchantId",merchantId);
                    data.put("userAuthToken",uAuthToken);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                String dataString64 = null;
                try {
                    dataString64 = Base64.encodeToString(data.toString().getBytes("UTF-8"), Base64.NO_WRAP);
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                String checksum1 = getCheckSum(dataString64, path, key);
                String sChecksumLimiter = "###";
                String checksum = checksum1 + sChecksumLimiter + keyIndex;
                WalletBalanceRequest walletBalanceRequest = new WalletBalanceRequest.WalletBalanceRequestBuilder()
                        .setChecksum(checksum)
                        .setData(dataString64)
                        .build();
                makeWalletBalanceCall(walletBalanceRequest, new DebitSuggestCallback() {
                    @Override
                    public void onSuccess() {
                        startTopup.setEnabled(true);
                    }

                    @Override
                    public void onFailure() {

                    }
                });
            }
        });
        startTopup.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //merchant will do this
                int keyIndex = 1;
                String merchantId = "DREAM11ONLINE";
                String uAuthToken = userAuthToken.getText().toString();
                Long amnt = Long.parseLong(amount.getText().toString()) * 100;
                String key = "6ab539dc-6ace-48c5-b957-75cb408e4f29";
                String path = "/v3/wallet/topup";
                JSONObject data = new JSONObject();
                try {
                    data.put("amount",amnt);
                    data.put("merchantId",merchantId);
                    data.put("userAuthToken",uAuthToken);
//                    data.put("linkType","PAYMENT");
//                    "recommendedAmounts": [0],
//                    "adjustAmount": true,
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                String dataString64 = null;
                try {
                    dataString64 = Base64.encodeToString(data.toString().getBytes("UTF-8"), Base64.NO_WRAP);
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                String checksum1 = getCheckSum(dataString64, path, key);
                String sChecksumLimiter = "###";
                String checksum = checksum1 + sChecksumLimiter + keyIndex;
                WalletTopUpRequest walletTopUpRequest = new WalletTopUpRequest.WalletTopUpRequestBuilder()
                        .setChecksum(checksum)
                        .setData(dataString64)
                        .build();
                makeWalletTopUpCall(walletTopUpRequest);
            }
        });
    }

    public void makeWalletTopUpCall(final WalletTopUpRequest walletTopUpRequest) {
        try {
            objectFactory = PhonePe.getObjectFactory();
            SDKContext sdkContext = this.objectFactory.<SDKContext>get(SDKContext.class);
            final APIHelper apiHelper = objectFactory.<APIHelper>get(APIHelper.class);
            final APIManager apiManager = objectFactory.<APIManager>get(APIManager.class);
            final Map<String, String> headers = objectFactory.getHashMap();
            Boolean isInUATMode = this.objectFactory.<Boolean>get(Constants.MerchantMeta.IS_UAT);
            final String endpoint = NetworkConstants.getApiBaseUrl(isInUATMode) + NetworkConstants.APIEndPoints.API_WALLET_TOPUP;
            headers.put("X-VERIFY", walletTopUpRequest.getChecksum());
            headers.put("Content-Type","application/json");
            final JSONObject finalPayload = new JSONObject();
            finalPayload.put("request", walletTopUpRequest.getData());
            finalPayload.put("sdkContext", sdkContext.toJsonObject());
            SdkLogger.d(TAG, "payload  -> " + walletTopUpRequest.getData() + "\n" + "base64Payload  -> " + finalPayload.toString() + "\n" + "X-VERIFY  -> " + walletTopUpRequest.getChecksum() + "\n");
            apiHelper.getCommonHeadersAdded(headers, new APIHelper.OnHeadersAddedListener() {
                @Override
                public void onHeadersAdded(Map<String, String> addedHeaders) {
                    apiManager.asyncPostRequest(endpoint, headers, finalPayload.toString(), new INetworkResponseListener() {
                        @Override
                        public void onSuccess(String response) {
                            WalletTopUpResponse walletTopUpResponse = WalletTopUpResponse.fromJsonString(response, objectFactory, WalletTopUpResponse.class);
                            SdkLogger.d(TAG, String.format("generateDeeplinkResponse status : {%s}", walletTopUpResponse.getSuccess()));
                            dlApiRsponse.setText(response);
                                try {
                                    if (walletTopUpResponse.getSuccess() && walletTopUpResponse.getData().getResponseType().equals(ResponseType.WALLET_TOPUP_DEEPLINK)) {
                                        Uri deeplink = Uri.parse(walletTopUpResponse.getData().getRedirectUrl());
                                        Intent intent = new Intent(Intent.ACTION_VIEW, deeplink);
                                        startActivityForResult(intent, PHONEPE_WALLET_TOPUP_REQUEST_CODE);
                                    }
                                } catch (PhonePeInitException e) {
                                    Toast.makeText(WalletTopUpActivity.this, "Deeplink API failed" + e.getLocalizedMessage(), Toast.LENGTH_SHORT).show();
                                    e.printStackTrace();
                                }
                        }
                        @Override
                        public void onFailure(int responseCode, String response) {
                            dlApiRsponse.setText(response);
                            SdkLogger.e(TAG, String.format("generateDeeplinkResponse ,responseCode = {%d}, response = {%s}", responseCode, response));
                            Toast.makeText(WalletTopUpActivity.this, "Deeplink API failed" + response, Toast.LENGTH_SHORT).show();
                        }
                    }, false);
                }
            });
        } catch (PhonePeInitException | JSONException e) {
            SdkLogger.e(TAG, "exception");
            e.printStackTrace();
        }
    }

    private String getCheckSum(String body, String endPoint, String salt) {
        try {
            CryptLib cryptLib = new CryptLib();
            byte[] hash = cryptLib.SHA256(body + endPoint + salt);
            StringBuffer hashtext = new StringBuffer();

            for (int i = 0; i < hash.length; i++) {
                String hex = Integer.toHexString(0xff & hash[i]);
                if (hex.length() == 1) hashtext.append('0');
                hashtext.append(hex);
            }
            // Uncomment this when you want to debug Checksum logic
            SdkLogger.d(TAG, "Body: " + body + "\nEndPoint: " + endPoint + "\nSalt: " + salt + "\nHashText:" + hashtext);
            return hashtext.toString();
        } catch (Exception e) {
            SdkLogger.e(TAG, e.getMessage(), e);
            return null;
        }
    }

    public void makeWalletBalanceCall(final WalletBalanceRequest walletBalanceRequest, final DebitSuggestCallback debitSuggestCallback) {
        try {
            objectFactory = PhonePe.getObjectFactory();
        } catch (PhonePeInitException e) {
            e.printStackTrace();
        }
        final APIHelper apiHelper = objectFactory.<APIHelper>get(APIHelper.class);
        final APIManager apiManager = objectFactory.<APIManager>get(APIManager.class);
        Boolean isInUATMode = this.objectFactory.<Boolean>get(Constants.MerchantMeta.IS_UAT);
        SDKContext sdkContext = this.objectFactory.<SDKContext>get(SDKContext.class);
        final String endpoint = NetworkConstants.getApiBaseUrl(isInUATMode) + NetworkConstants.APIEndPoints.API_WALLET_BALANCE;
        final Map<String, String> headers = objectFactory.getHashMap();
        headers.put("X-VERIFY", walletBalanceRequest.getChecksum());
        headers.put("Content-Type", "application/json");
        final JSONObject finalPayload = new JSONObject();
        try {
            finalPayload.put("request", walletBalanceRequest.getData());
            finalPayload.put("sdkContext", sdkContext.toJsonObject());
            SdkLogger.d(TAG, "payload  -> " + walletBalanceRequest.getData() + "\n" + "base64Payload  -> " + finalPayload.toString() + "\n" + "X-VERIFY  -> " + walletBalanceRequest.getChecksum() + "\n");
            apiHelper.getCommonHeadersAdded(headers, new APIHelper.OnHeadersAddedListener() {
                @Override
                public void onHeadersAdded(Map<String, String> addedHeaders) {
                    apiManager.asyncPostRequest(endpoint, addedHeaders, finalPayload.toString(), new INetworkResponseListener() {
                        @Override
                        public void onSuccess(String response) {
                            Log.d("makeDebitSuggestCall", response);
                            apiResponse.setText(response);
                            WalletBalanceResponse walletBalanceResponse = WalletBalanceResponse.fromJsonString(response, objectFactory, WalletBalanceResponse.class);
                            if (walletBalanceResponse.getSuccess()) {
                                try {
//                            final long usableWalletBalance = debitSuggestResponse.getData().getWallet().getUsableBalance();
                                    final boolean walletActive = walletBalanceResponse.getData().getWallet().getWalletActive();
                                    final boolean walletTopupSuggested = walletBalanceResponse.getData().getWallet().getWalletTopUpSuggested();
//                            final Integer maxTopupAllowed = debitSuggestResponse.getData().getWallet().getMaxTopupAllowed();
//                            final long availableBalance = debitSuggestResponse.getData().getWallet().getAvailableBalance();
                                    String hashedUserId = walletBalanceResponse.getData().getUserId();
                                    try {
                                        JSONObject constraints = new JSONObject();
                                        constraints.put("hashedUserId", hashedUserId);
                                        constraints.put("checkUserValidity", true);
                                        constraints.put("checkLoggedIn", true);
                                        PhonePe.request("shouldShowPhonePeWalletTopUp", constraints.toString(), new RequestCallback() {
                                            @Override
                                            public void onResponse(String result) {
                                                Log.d("SDKtoAppCommunication", "Got Callback: " + result);
                                                if (result != null && !result.isEmpty()) {
                                                    try {
                                                        JSONObject response = new JSONObject(result);
                                                        boolean isUserValid = response.optBoolean("userValid");
                                                        boolean isUserLoggedIn = response.optBoolean("loggedIn");
                                                        boolean isWalletTopupViaDeeplinkSupported = response.optBoolean("walletTopupViaDeeplinkSupported");
                                                        responseTv.setText("isUserValid " + isUserValid + "\n allowWalletTopUp " + walletActive + "\n isUserLoggedIn " + isUserLoggedIn + "\nisWalletTopupViaDeeplinkSupported " + isWalletTopupViaDeeplinkSupported + "\n walletTopupSuggested " + walletTopupSuggested);
//                                                if (isUserValid && (usableWalletBalance >= txnAmount)) {
//                                                    // call direct debit
//                                                    Toast.makeText(WalletTopUpActivity.this, "Amount is sufficient - will directly call direct/debit", Toast.LENGTH_SHORT).show();
//                                                    debitSuggestCallback.onFailure();
//                                                    return;
//                                                }
//                                                //todo: set errorCode - LIMIT_EXHAUSTED
//                                                if (isUserValid && walletActive && ((usableWalletBalance + maxTopupAllowed) >= txnAmount) && ( availableBalance == usableWalletBalance ))  {
//                                                    // showIcon
//                                                    // todo: send data here
//                                                    debitSuggestCallback.onSuccess();
//                                                }
                                                        if(isUserValid && walletActive && walletTopupSuggested) {
                                                            debitSuggestCallback.onSuccess();
                                                        }
                                                    } catch (JSONException e) {
                                                        Toast.makeText(WalletTopUpActivity.this, "shouldShowPhonePeWalletTopUp failed", Toast.LENGTH_SHORT).show();
                                                        e.printStackTrace();
                                                    }
                                                }
                                            }
                                        });
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }

                                } catch (PhonePeInitException e) {
                                    e.printStackTrace();
                                }
                            }
                        }

                        @Override
                        public void onFailure(int responseCode, String error) {
                            apiResponse.setText(error);
                            Toast.makeText(WalletTopUpActivity.this, "/debit/suggest failed " + error, Toast.LENGTH_SHORT).show();
                        }
                    }, true);

                }
            });
        } catch (JSONException e) {
            e.printStackTrace();
        }

    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        //todo: handle result
        if(requestCode == PHONEPE_WALLET_TOPUP_REQUEST_CODE) {
            if(data != null) {
                Log.d("onActivityResult",data.getStringExtra("response"));
                responseTv.setText(data.getStringExtra("response"));
                setResult(resultCode, data);
            }
        }
    }
}
