package com.phonepe.intent.sdk.widgets;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.util.AttributeSet;
import android.view.View;
import android.webkit.WebSettings;
import android.webkit.WebView;

import com.phonepe.intent.sdk.api.PhonePe;
import com.phonepe.intent.sdk.api.PhonePeInitException;
import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.utils.Constants;
import com.phonepe.intent.sdk.utils.SdkLogger;
import com.phonepe.intent.sdk.utils.Utils;

/**
 * @author Sharath Pandeshwar
 * @since 28/04/17.
 */
public class PhWebView extends WebView {

    private ObjectFactory objectFactory;
    public static final String TAG = "PhWebView";

    public PhWebView(Context context) {
        super(context);
        try {
            init(PhonePe.getObjectFactory());
        } catch (PhonePeInitException e) {
            SdkLogger.e(TAG, e.getMessage(), e);
        }
    }

    public PhWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        try {
            init(PhonePe.getObjectFactory());
        } catch (PhonePeInitException e) {
            SdkLogger.e(TAG, e.getMessage(), e);
        }
    }

    public PhWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        try {
            init(PhonePe.getObjectFactory());
        } catch (PhonePeInitException e) {
            SdkLogger.e(TAG, e.getMessage(), e);
        }

    }

    /**
     * @param objectFactory for accessing PhonePe SDK assets.
     */
    @VisibleForTesting
    private void init(@NonNull ObjectFactory objectFactory) {

        SdkLogger.v(TAG, "initialization started ..");
        this.objectFactory = objectFactory;
        getSettings().setJavaScriptEnabled(true);
        getSettings().setDomStorageEnabled(true);
        getSettings().setBuiltInZoomControls(false);
        getSettings().setAppCacheEnabled(true);
        getSettings().setCacheMode(WebSettings.LOAD_DEFAULT);
        requestFocus(View.FOCUS_DOWN);
        setBackgroundColor(Color.WHITE);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT
                && Utils.isTrue(this.objectFactory.<Boolean>get(Constants.MerchantMeta.DEBUGGABLE))) {
            WebView.setWebContentsDebuggingEnabled(true);
        }

        SdkLogger.v(TAG, "initialization completed.");
    }
}
