/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.common;

import com.phonepe.models.common.User;
import com.phonepe.models.common.enums.UserType;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

public class MerchantUser
extends User {
    @NotNull
    @NotEmpty
    @Length(min=1, max=64)
    private String id;

    public MerchantUser() {
        super(UserType.MERCHANT_USER_ID);
    }

    public MerchantUser(String id) {
        this();
        this.id = id;
    }

    public static MerchantUserBuilder builder() {
        return new MerchantUserBuilder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MerchantUser)) {
            return false;
        }
        MerchantUser other = (MerchantUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MerchantUser;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MerchantUser(super=" + super.toString() + ", id=" + this.getId() + ")";
    }

    public static class MerchantUserBuilder {
        private String id;

        MerchantUserBuilder() {
        }

        public MerchantUserBuilder id(String id) {
            this.id = id;
            return this;
        }

        public MerchantUser build() {
            return new MerchantUser(this.id);
        }

        public String toString() {
            return "MerchantUser.MerchantUserBuilder(id=" + this.id + ")";
        }
    }
}

