/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.request;

import com.phonepe.models.common.enums.RefundCategory;
import com.phonepe.models.request.BaseRequest;
import java.beans.ConstructorProperties;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

public class RefundRequest
extends BaseRequest {
    @NotNull
    @NotEmpty
    @Length(min=1, max=64)
    private String merchantTransactionId;
    @NotNull
    @NotEmpty
    @Length(min=1, max=64)
    private String merchantOrderId;
    @NotNull
    private RefundCategory refundCategory;
    private String message;

    public static RefundRequestBuilder builder() {
        return new RefundRequestBuilder();
    }

    public String getMerchantTransactionId() {
        return this.merchantTransactionId;
    }

    public String getMerchantOrderId() {
        return this.merchantOrderId;
    }

    public RefundCategory getRefundCategory() {
        return this.refundCategory;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMerchantTransactionId(String merchantTransactionId) {
        this.merchantTransactionId = merchantTransactionId;
    }

    public void setMerchantOrderId(String merchantOrderId) {
        this.merchantOrderId = merchantOrderId;
    }

    public void setRefundCategory(RefundCategory refundCategory) {
        this.refundCategory = refundCategory;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public RefundRequest() {
    }

    @ConstructorProperties(value={"merchantTransactionId", "merchantOrderId", "refundCategory", "message"})
    public RefundRequest(String merchantTransactionId, String merchantOrderId, RefundCategory refundCategory, String message) {
        this.merchantTransactionId = merchantTransactionId;
        this.merchantOrderId = merchantOrderId;
        this.refundCategory = refundCategory;
        this.message = message;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RefundRequest)) {
            return false;
        }
        RefundRequest other = (RefundRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$merchantTransactionId = this.getMerchantTransactionId();
        String other$merchantTransactionId = other.getMerchantTransactionId();
        if (this$merchantTransactionId == null ? other$merchantTransactionId != null : !this$merchantTransactionId.equals(other$merchantTransactionId)) {
            return false;
        }
        String this$merchantOrderId = this.getMerchantOrderId();
        String other$merchantOrderId = other.getMerchantOrderId();
        if (this$merchantOrderId == null ? other$merchantOrderId != null : !this$merchantOrderId.equals(other$merchantOrderId)) {
            return false;
        }
        RefundCategory this$refundCategory = this.getRefundCategory();
        RefundCategory other$refundCategory = other.getRefundCategory();
        if (this$refundCategory == null ? other$refundCategory != null : !((Object)((Object)this$refundCategory)).equals((Object)other$refundCategory)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RefundRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $merchantTransactionId = this.getMerchantTransactionId();
        result = result * 59 + ($merchantTransactionId == null ? 43 : $merchantTransactionId.hashCode());
        String $merchantOrderId = this.getMerchantOrderId();
        result = result * 59 + ($merchantOrderId == null ? 43 : $merchantOrderId.hashCode());
        RefundCategory $refundCategory = this.getRefundCategory();
        result = result * 59 + ($refundCategory == null ? 43 : ((Object)((Object)$refundCategory)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RefundRequest(super=" + super.toString() + ", merchantTransactionId=" + this.getMerchantTransactionId() + ", merchantOrderId=" + this.getMerchantOrderId() + ", refundCategory=" + (Object)((Object)this.getRefundCategory()) + ", message=" + this.getMessage() + ")";
    }

    public static class RefundRequestBuilder {
        private String merchantTransactionId;
        private String merchantOrderId;
        private RefundCategory refundCategory;
        private String message;

        RefundRequestBuilder() {
        }

        public RefundRequestBuilder merchantTransactionId(String merchantTransactionId) {
            this.merchantTransactionId = merchantTransactionId;
            return this;
        }

        public RefundRequestBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public RefundRequestBuilder refundCategory(RefundCategory refundCategory) {
            this.refundCategory = refundCategory;
            return this;
        }

        public RefundRequestBuilder message(String message) {
            this.message = message;
            return this;
        }

        public RefundRequest build() {
            return new RefundRequest(this.merchantTransactionId, this.merchantOrderId, this.refundCategory, this.message);
        }

        public String toString() {
            return "RefundRequest.RefundRequestBuilder(merchantTransactionId=" + this.merchantTransactionId + ", merchantOrderId=" + this.merchantOrderId + ", refundCategory=" + (Object)((Object)this.refundCategory) + ", message=" + this.message + ")";
        }
    }
}

