/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.request;

import com.phonepe.models.common.User;
import com.phonepe.models.common.enums.CurrencyCode;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public abstract class BaseRequest {
    @NotNull
    @Valid
    private User user;
    @NotNull
    @Min(value=1L)
    private long amount;
    @NotNull
    private CurrencyCode currencyCode;

    protected BaseRequest(User user, long amount, CurrencyCode currencyCode) {
        this.amount = amount;
        this.currencyCode = currencyCode;
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public long getAmount() {
        return this.amount;
    }

    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseRequest)) {
            return false;
        }
        BaseRequest other = (BaseRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        CurrencyCode this$currencyCode = this.getCurrencyCode();
        CurrencyCode other$currencyCode = other.getCurrencyCode();
        return !(this$currencyCode == null ? other$currencyCode != null : !((Object)((Object)this$currencyCode)).equals((Object)other$currencyCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        long $amount = this.getAmount();
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        CurrencyCode $currencyCode = this.getCurrencyCode();
        result = result * 59 + ($currencyCode == null ? 43 : ((Object)((Object)$currencyCode)).hashCode());
        return result;
    }

    public String toString() {
        return "BaseRequest(user=" + this.getUser() + ", amount=" + this.getAmount() + ", currencyCode=" + (Object)((Object)this.getCurrencyCode()) + ")";
    }
}

