/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.request;

import com.phonepe.models.common.User;
import com.phonepe.models.common.enums.CurrencyCode;
import com.phonepe.models.request.BaseRequest;
import java.beans.ConstructorProperties;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

public class ReversalRequest
extends BaseRequest {
    @NotNull
    @NotEmpty
    @Length(min=1, max=64)
    private String merchantTransactionId;
    @NotNull
    @NotEmpty
    @Length(min=1, max=64)
    private String merchantOrderId;
    @NotNull
    @NotEmpty
    @Length(min=1, max=64)
    private String originalTransactionId;
    private String cancelReason;

    public ReversalRequest(User user, long amount, CurrencyCode currencyCode) {
        super(user, amount, currencyCode);
    }

    public ReversalRequest(User user, long amount, CurrencyCode currencyCode, String merchantTransactionId, String merchantOrderId, String originalTransactionId, String cancelReason) {
        this(user, amount, currencyCode);
        this.merchantTransactionId = merchantTransactionId;
        this.merchantOrderId = merchantOrderId;
        this.originalTransactionId = originalTransactionId;
        this.cancelReason = cancelReason;
    }

    public static ReversalRequestBuilder builder() {
        return new ReversalRequestBuilder();
    }

    public String getMerchantTransactionId() {
        return this.merchantTransactionId;
    }

    public String getMerchantOrderId() {
        return this.merchantOrderId;
    }

    public String getOriginalTransactionId() {
        return this.originalTransactionId;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }

    public void setMerchantTransactionId(String merchantTransactionId) {
        this.merchantTransactionId = merchantTransactionId;
    }

    public void setMerchantOrderId(String merchantOrderId) {
        this.merchantOrderId = merchantOrderId;
    }

    public void setOriginalTransactionId(String originalTransactionId) {
        this.originalTransactionId = originalTransactionId;
    }

    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReversalRequest)) {
            return false;
        }
        ReversalRequest other = (ReversalRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$merchantTransactionId = this.getMerchantTransactionId();
        String other$merchantTransactionId = other.getMerchantTransactionId();
        if (this$merchantTransactionId == null ? other$merchantTransactionId != null : !this$merchantTransactionId.equals(other$merchantTransactionId)) {
            return false;
        }
        String this$merchantOrderId = this.getMerchantOrderId();
        String other$merchantOrderId = other.getMerchantOrderId();
        if (this$merchantOrderId == null ? other$merchantOrderId != null : !this$merchantOrderId.equals(other$merchantOrderId)) {
            return false;
        }
        String this$originalTransactionId = this.getOriginalTransactionId();
        String other$originalTransactionId = other.getOriginalTransactionId();
        if (this$originalTransactionId == null ? other$originalTransactionId != null : !this$originalTransactionId.equals(other$originalTransactionId)) {
            return false;
        }
        String this$cancelReason = this.getCancelReason();
        String other$cancelReason = other.getCancelReason();
        return !(this$cancelReason == null ? other$cancelReason != null : !this$cancelReason.equals(other$cancelReason));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReversalRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $merchantTransactionId = this.getMerchantTransactionId();
        result = result * 59 + ($merchantTransactionId == null ? 43 : $merchantTransactionId.hashCode());
        String $merchantOrderId = this.getMerchantOrderId();
        result = result * 59 + ($merchantOrderId == null ? 43 : $merchantOrderId.hashCode());
        String $originalTransactionId = this.getOriginalTransactionId();
        result = result * 59 + ($originalTransactionId == null ? 43 : $originalTransactionId.hashCode());
        String $cancelReason = this.getCancelReason();
        result = result * 59 + ($cancelReason == null ? 43 : $cancelReason.hashCode());
        return result;
    }

    @ConstructorProperties(value={"merchantTransactionId", "merchantOrderId", "originalTransactionId", "cancelReason"})
    public ReversalRequest(String merchantTransactionId, String merchantOrderId, String originalTransactionId, String cancelReason) {
        this.merchantTransactionId = merchantTransactionId;
        this.merchantOrderId = merchantOrderId;
        this.originalTransactionId = originalTransactionId;
        this.cancelReason = cancelReason;
    }

    public ReversalRequest() {
    }

    @Override
    public String toString() {
        return "ReversalRequest(super=" + super.toString() + ", merchantTransactionId=" + this.getMerchantTransactionId() + ", merchantOrderId=" + this.getMerchantOrderId() + ", originalTransactionId=" + this.getOriginalTransactionId() + ", cancelReason=" + this.getCancelReason() + ")";
    }

    public static class ReversalRequestBuilder {
        private User user;
        private long amount;
        private CurrencyCode currencyCode;
        private String merchantTransactionId;
        private String merchantOrderId;
        private String originalTransactionId;
        private String cancelReason;

        ReversalRequestBuilder() {
        }

        public ReversalRequestBuilder user(User user) {
            this.user = user;
            return this;
        }

        public ReversalRequestBuilder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public ReversalRequestBuilder currencyCode(CurrencyCode currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public ReversalRequestBuilder merchantTransactionId(String merchantTransactionId) {
            this.merchantTransactionId = merchantTransactionId;
            return this;
        }

        public ReversalRequestBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public ReversalRequestBuilder originalTransactionId(String originalTransactionId) {
            this.originalTransactionId = originalTransactionId;
            return this;
        }

        public ReversalRequestBuilder cancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
            return this;
        }

        public ReversalRequest build() {
            return new ReversalRequest(this.user, this.amount, this.currencyCode, this.merchantTransactionId, this.merchantOrderId, this.originalTransactionId, this.cancelReason);
        }

        public String toString() {
            return "ReversalRequest.ReversalRequestBuilder(user=" + this.user + ", amount=" + this.amount + ", currencyCode=" + (Object)((Object)this.currencyCode) + ", merchantTransactionId=" + this.merchantTransactionId + ", merchantOrderId=" + this.merchantOrderId + ", originalTransactionId=" + this.originalTransactionId + ", cancelReason=" + this.cancelReason + ")";
        }
    }
}

