/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.common.enums;

import com.phonepe.models.common.enums.PaymentState;
import java.util.Map;

public enum ResponseCode {
    INVALID_RECIPIENTS(400, "Pay request has invalid users"),
    INVALID_REQUEST(401, "Invalid request"),
    DUPLICATE_TXN_REQUEST(402, "Has sent a duplicate transaction id"),
    REMINDER_TOO_FREQUENT(403, "Only one reminder can be sent in a day"),
    INVALID_TRANSACTION_ID(404, "Invalid merchant transaction id"),
    ACCOUNT_NOT_FOUND(406, "Account does not exists"),
    DEVICE_NOT_FOUND(407, "Device does not exists"),
    INVALID_IFSC(408, "No Branch found for IFSC"),
    ORIGINAL_TRANSACTION_NOT_FOUND(100, "Could not identify the original transaction "),
    EXCESS_REFUND_AMOUNT(101, "The refund amount exceeds the maximum refundable amount allowed for this transaction"),
    INSUFFICIENT_FUNDS(103, "There is insufficient balance in the customer's account"),
    TRANSACTION_NOT_ALLOWED(102, "The transaction is not eligible for the wallet state"),
    WALLET_NOT_FOUND(104, "The wallet does not exists"),
    TRANSACTION_LIMIT_EXCEEDED(105, "Transaction amount has exceeded the txn limit"),
    OPERATION_NOT_SUPPORTED(106, "Operation not supported"),
    USER_NOT_FOUND(304, "No user found"),
    USER_SERVICE_EXCEPTION(305, "User service exception"),
    SUCCESS(200, "Successful", PaymentState.COMPLETED),
    CREATED(204, "The transaction has been initiated", PaymentState.CREATED),
    PENDING(205, "The transaction is currently pending", PaymentState.ONBOARDING_REQUESTED),
    INTERNAL_SERVER_ERROR(500, "Server Error "),
    DAO_EXCEPTION(501, "Data Access Error "),
    QUEUE_EXCEPTION(502, "Error while pushing to queue"),
    FEED_SERVICE_EXCEPTION(503, "Feed service exception"),
    FLIPCAST_SERVICE_EXCEPTION(504, "Flipcast exception"),
    REVOLVER_SERVICE_EXCEPTION(505, "Revolver exception"),
    WALLET_SERVICE_EXCEPTION(506, "Wallet service exception"),
    ACCOUNTING_SERVICE_EXCEPTION(507, "Accounting service exception"),
    EVENT_SERVICE_EXCEPTION(508, "Event Ingestion service exception"),
    UPI_BACKBONE_ERROR(601, "Error in UPI backbone");

    private final String message;
    private final PaymentState state;
    private final int code;

    private ResponseCode(int code, String msg, PaymentState state) {
        this.code = code;
        this.message = msg;
        this.state = state;
    }

    private ResponseCode(int code, String msg) {
        this.code = code;
        this.message = msg;
        this.state = PaymentState.FAILED;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessage(Map<String, String> params) {
        String message = this.message;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            message = message.replace('<' + entry.getKey() + '>', entry.getValue());
        }
        return message;
    }

    public boolean isSuccess() {
        return this.state == PaymentState.COMPLETED;
    }
}

