/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.common.enums;

import com.phonepe.models.common.enums.PaymentState;
import java.util.Map;

public enum ResponseCode {
    INVALID_RECIPIENTS(400, "Pay request has invalid users"),
    INVALID_REQUEST(401, "Invalid request"),
    DUPLICATE_TXN_REQUEST(402, "Has sent a duplicate transaction id"),
    REMINDER_TOO_FREQUENT(403, "Only one reminder can be sent in a day"),
    INVALID_TRANSACTION_ID(404, "Invalid merchant transaction id"),
    ACCOUNT_NOT_FOUND(406, "Account does not exists"),
    DEVICE_NOT_FOUND(407, "Device does not exists"),
    INVALID_IFSC(408, "No Branch found for IFSC"),
    AUTHORIZATION_FAILED(409, "Auth fail"),
    NO_PRIMARY_VPA(410, "No primary VPA for user"),
    PAYMENT_ALREADY_UNDERWAY(411, "Payment already underway for this request"),
    SPLIT_TO_EXTERNAL_UNSUPPORTED(412, "Multiple payees not allowed in external collect"),
    PAYMENT_ALREADY_COMPLETED(415, "Payment already completed"),
    ORIGINAL_TRANSACTION_NOT_FOUND(100, "Could not identify the original transaction "),
    EXCESS_REFUND_AMOUNT(101, "The refund amount exceeds the maximum refundable amount allowed for this transaction"),
    INSUFFICIENT_FUNDS(103, "There is insufficient balance in the customer's account"),
    TRANSACTION_NOT_ALLOWED(102, "The transaction is not eligible for the wallet state"),
    WALLET_NOT_FOUND(104, "The wallet does not exists"),
    TRANSACTION_LIMIT_EXCEEDED(105, "Transaction amount has exceeded the txn limit"),
    OPERATION_NOT_SUPPORTED(106, "Operation not supported"),
    OPERATION_CANT_BE_PERFORMED_IN_THIS_STATE(450, "Operation can't be performed in this state"),
    INVALID_PROGRAM_ID(451, "Invalid program id"),
    INVALID_TOKEN(452, "Invalid token"),
    MISSING_KYC(453, "Missing kyc"),
    AMOUNT_HIGHER_THAN_ALLOWED(454, "Amount higher than max allowed value"),
    CREATED_WITH_DIFFERENT_INVOICE_NUMBER(455, "Created with different invoice number"),
    ORIGINAL_BALANCE_NOT_SAME_AS_CURRENT_BALANCE(456, "Original balance not same as current balance"),
    CARD_EXPIRED(457, "Card expired"),
    CARD_BLOCKED(458, "Card blocked"),
    CARD_DEACTIVATED(459, "Card deactivated"),
    CARD_NOT_ACTIVATED(460, "Card not activated"),
    CARD_CANCELLED(461, "Card cancelled"),
    INVOICE_MISMATCH(462, "Invoice mismatch"),
    AMOUNT_HIGHER_THAN_REDEEM(463, "Amount higher than redeem"),
    CARD_DOESNT_EXIST(464, "Card doesn't exist"),
    NOT_ALLOWED_FOR_PROGRAM(465, "Not allowed for program"),
    CARD_AUTHORIZATION_FAILED(466, "Card auth failed"),
    CARD_AUTHORIZATION_FAILED_CARD_BLOCKED(467, "Card auth failed. Card is blocked"),
    USER_NOT_FOUND(304, "No user found"),
    USER_SERVICE_EXCEPTION(305, "User service exception"),
    USER_BLACKLISTED(306, "Blacklisted user"),
    SUCCESS(200, "Successful", PaymentState.COMPLETED),
    CREATED(204, "The transaction has been initiated", PaymentState.CREATED),
    PENDING(205, "The transaction is currently pending", PaymentState.ONBOARDING_REQUESTED),
    INTERNAL_SERVER_ERROR(500, "Server Error "),
    DAO_EXCEPTION(501, "Data Access Error "),
    QUEUE_EXCEPTION(502, "Error while pushing to queue"),
    FEED_SERVICE_EXCEPTION(503, "Feed service exception"),
    FLIPCAST_SERVICE_EXCEPTION(504, "Flipcast exception"),
    REVOLVER_SERVICE_EXCEPTION(505, "Revolver exception"),
    WALLET_SERVICE_EXCEPTION(506, "Wallet service exception"),
    ACCOUNTING_SERVICE_EXCEPTION(507, "Accounting service exception"),
    EVENT_SERVICE_EXCEPTION(508, "Event Ingestion service exception"),
    NON_RETRYABLE_TRANSACTION(509, "Cannot retry this transaction"),
    REQUEST_FAILED(510, "Collect request failed at UPI"),
    REQUEST_TIME_OUT(511, "Request Timed out"),
    MERCHANT_SERVICE_EXCEPTION(512, "Merchant service exception"),
    PG_BACKBONE_ERROR(605, "Error in PG backbone"),
    UPI_BACKBONE_ERROR(601, "Error in UPI backbone"),
    REQUEST_CANCEL_BY_REQUESTER(602, "User canceled the request"),
    REQUEST_DECLINE_BY_REQUESTEE(603, "User Declined the request"),
    CRED_BLOCK_NOT_FOUND(604, "Mpin missed"),
    INVALID_CARD(606, "Wrong card details"),
    CARD_NOT_SUPPORTED(607, "Card not supported"),
    CREDIT_CARD_NOT_SUPPORTED(608, "Credit Card not supported"),
    BLOCKED_FRAUD(700, "Transaction blocked due to suspected fraud");

    private final String message;
    private final PaymentState state;
    private final int code;

    private ResponseCode(int code, String msg, PaymentState state) {
        this.code = code;
        this.message = msg;
        this.state = state;
    }

    private ResponseCode(int code, String msg) {
        this.code = code;
        this.message = msg;
        this.state = PaymentState.FAILED;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessage(Map<String, String> params) {
        String message = this.message;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            message = message.replace('<' + entry.getKey() + '>', entry.getValue());
        }
        return message;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isSuccess() {
        return this.state == PaymentState.COMPLETED;
    }
}

