package com.phonepe.sdk.javasdk.http.utils;

import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.models.Endpoint;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import lombok.extern.slf4j.Slf4j;
import okhttp3.*;
import java.io.IOException;
import java.net.URI;

/**
 * Utils class containing helper methods for Http.
 */
@Slf4j
public final class HttpUtils {

    public static byte[] body(final Response response) throws IOException {
        try {
            final ResponseBody body = response.body();
            return body.bytes();
        } catch (IOException ex){
            log.error("Exception occurred while performing response to byte conversion");
        }
        return null;
    }

    /**
     *
     * @param {@link Response}
     * @return  {@link String}
     * @throws IOException
     */
    public static String bodyString(final Response response) throws IOException {
        try{
            final ResponseBody body = response.body();
            return body.string();
        }catch (IOException ex){
            log.error("Exception occurred while performing response to byte conversion");
        }
        return null;
    }

    /**
     * @param endpoint host port details
     * @param url              uri path
     * @return secure {@link HttpUrl}
     */
    public static HttpUrl getSecureHttpUrl(final Endpoint endpoint, final String url) {
        Preconditions.checkNotNull(endpoint);
        return endpoint.secureUrl(url);
    }

    /**
     * @param endpoint host port details
     * @param url              uri path
     * @return secure {@link HttpUrl}
     */
    public static HttpUrl getHttpUrl(final Endpoint endpoint, final String url) {
        Preconditions.checkNotNull(endpoint);
        return endpoint.url(url);
    }

    public static HttpHeaderPair getHeaderPair(final String name, final String value){
        return HttpHeaderPair.builder()
                             .name(name)
                             .value(value)
                             .build();
    }

    public static HttpHeaderPair getContentTypeHeaderPair(){
        return getHeaderPair("Content-Type", "application/json");
    }
}

