package com.phonepe.sdk.javasdk.transaction.init.web;

import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator;
import lombok.Builder;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class WebTransactionInitiator extends TransactionInitiator {


    @Builder
    public WebTransactionInitiator(final TransactionClient transactionClient,
                                   final InitConfig initConfig,
                                   final MerchantConfig merchantConfig) {
        super(transactionClient, initConfig, merchantConfig);
    }

    @Override
    protected InitRequest buildInitRequest(String merchantId,
                                           String transactionId,
                                           String userId,
                                           Long amount,
                                           String orderId) {
        return InitRequest.builder()
                          .merchantId(merchantId)
                          .transactionId(transactionId)
                          .merchantOrderId(orderId)
                          .merchantUserId(userId)
                          .amount(amount)
                          .mobileNumber("9930381072")
                          .build();
    }

}
