/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.status;

import com.github.rholder.retry.Retryer;
import com.google.common.base.Predicate;
import com.phonepe.sdk.javasdk.config.models.APIKeyConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.StatusConfig;
import com.phonepe.sdk.javasdk.http.PhonePeException;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpResponse;
import com.phonepe.sdk.javasdk.http.utils.HttpUtils;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.status.models.StatusResponse;
import com.phonepe.sdk.javasdk.transaction.status.models.TransactionStatusResponse;
import com.phonepe.sdk.javasdk.transaction.status.models.enums.PaymentState;
import com.phonepe.sdk.javasdk.utils.ChecksumUtils;
import com.phonepe.sdk.javasdk.utils.RetryUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionStatusChecker {
    private static final Logger log = LoggerFactory.getLogger(TransactionStatusChecker.class);
    private TransactionClient transactionClient;
    private StatusConfig statusConfig;
    private MerchantConfig merchantConfig;

    public TransactionStatusChecker(TransactionClient transactionClient, MerchantConfig merchantConfig, StatusConfig statusConfig) {
        this.transactionClient = transactionClient;
        this.merchantConfig = merchantConfig;
        this.statusConfig = statusConfig;
    }

    public StatusResponse checkTransactionStatus(String transactionId) {
        return this.checkTransactionStatus(transactionId, 1);
    }

    public StatusResponse checkTransactionStatus(String transactionId, int keyIndex) {
        StatusResponse statusResponse = null;
        try {
            String apiURL = this.getAPIURL(this.merchantConfig.getMerchantId(), transactionId);
            String apiKey = this.getAPIKeyFromIndex(keyIndex);
            String checksumBody = ChecksumUtils.generateChecksumBody("", apiURL, apiKey);
            String checksumHeader = ChecksumUtils.generateChecksumHeader(checksumBody, keyIndex);
            List<HttpHeaderPair> httpHeaders = this.getHttpHeaders(checksumHeader);
            Callable<PhonePeHttpResponse<TransactionStatusResponse>> transactionStatusCallable = this.getCallable(apiURL, httpHeaders);
            Predicate<PhonePeHttpResponse<TransactionStatusResponse>> phonePeHttpResponsePredicate = this.getRetryPredicate();
            Retryer<PhonePeHttpResponse<TransactionStatusResponse>> retryer = RetryUtils.getRetryer(this.statusConfig.getRetryConfig(), phonePeHttpResponsePredicate);
            PhonePeHttpResponse phonePeHttpResponse = (PhonePeHttpResponse)retryer.call(transactionStatusCallable);
            statusResponse = this.buildStatusResponse(phonePeHttpResponse);
        }
        catch (Exception ex) {
            log.error("Exception occurred while performing transaction status check");
        }
        return statusResponse;
    }

    private String getAPIURL(String merchantId, String transactionId) {
        return String.format("/%s/transaction/%s/%s/status", this.statusConfig.getApiVersion().getApiVersion(), merchantId, transactionId);
    }

    private List<HttpHeaderPair> getHttpHeaders(String checksumHeader) {
        ArrayList<HttpHeaderPair> headerPairs = new ArrayList<HttpHeaderPair>();
        HttpHeaderPair httpHeaderPair = HttpUtils.getHeaderPair("X-VERIFY", checksumHeader);
        HttpHeaderPair contentTypeHeaderPair = HttpUtils.getContentTypeHeaderPair();
        headerPairs.add(contentTypeHeaderPair);
        return Collections.singletonList(httpHeaderPair);
    }

    private String getAPIKeyFromIndex(int keyIndex) throws Exception {
        for (APIKeyConfig apiKey : this.merchantConfig.getApiKeys()) {
            if (apiKey.getKeyIndex() != keyIndex) continue;
            return apiKey.getKeyValue();
        }
        throw new PhonePeException();
    }

    private Callable<PhonePeHttpResponse<TransactionStatusResponse>> getCallable(final String apiURL, final List<HttpHeaderPair> headerPairs) {
        return new Callable<PhonePeHttpResponse<TransactionStatusResponse>>(){

            @Override
            public PhonePeHttpResponse<TransactionStatusResponse> call() throws Exception {
                return TransactionStatusChecker.this.transactionClient.getTransactionStatus(headerPairs, apiURL);
            }
        };
    }

    private Predicate<PhonePeHttpResponse<TransactionStatusResponse>> getRetryPredicate() {
        return new Predicate<PhonePeHttpResponse<TransactionStatusResponse>>(){

            public boolean apply(@Nullable PhonePeHttpResponse<TransactionStatusResponse> transactionStatusResponse) {
                return transactionStatusResponse.getCode().equalsIgnoreCase("PAYMENT_PENDING") || transactionStatusResponse.getCode().equalsIgnoreCase("INTERNAL_SERVER_ERROR");
            }
        };
    }

    private StatusResponse buildStatusResponse(PhonePeHttpResponse<TransactionStatusResponse> transactionStatusResponse) {
        return StatusResponse.builder().merchantId(transactionStatusResponse.getData().getMerchantId()).transactionId(transactionStatusResponse.getData().getTransactionId()).paymentState(this.getPaymentState(transactionStatusResponse.getCode())).build();
    }

    private PaymentState getPaymentState(String statusCode) {
        if ("PAYMENT_SUCCESS".equalsIgnoreCase(statusCode)) {
            return PaymentState.PAYMENT_SUCCESS;
        }
        if ("PAYMENT_ERROR".equalsIgnoreCase(statusCode) || "PAYMENT_DECLINED".equalsIgnoreCase(statusCode) || "PAYMENT_CANCELLED".equalsIgnoreCase(statusCode) || "TRANSACTION_NOT_FOUND".equalsIgnoreCase(statusCode)) {
            return PaymentState.PAYMENT_FAILED;
        }
        return PaymentState.PAYMENT_PENDING;
    }

    public static TransactionStatusCheckerBuilder builder() {
        return new TransactionStatusCheckerBuilder();
    }

    public static class TransactionStatusCheckerBuilder {
        private TransactionClient transactionClient;
        private MerchantConfig merchantConfig;
        private StatusConfig statusConfig;

        TransactionStatusCheckerBuilder() {
        }

        public TransactionStatusCheckerBuilder transactionClient(TransactionClient transactionClient) {
            this.transactionClient = transactionClient;
            return this;
        }

        public TransactionStatusCheckerBuilder merchantConfig(MerchantConfig merchantConfig) {
            this.merchantConfig = merchantConfig;
            return this;
        }

        public TransactionStatusCheckerBuilder statusConfig(StatusConfig statusConfig) {
            this.statusConfig = statusConfig;
            return this;
        }

        public TransactionStatusChecker build() {
            return new TransactionStatusChecker(this.transactionClient, this.merchantConfig, this.statusConfig);
        }

        public String toString() {
            return "TransactionStatusChecker.TransactionStatusCheckerBuilder(transactionClient=" + this.transactionClient + ", merchantConfig=" + this.merchantConfig + ", statusConfig=" + this.statusConfig + ")";
        }
    }
}

