/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.http;

import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.models.HttpClientConfig;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhonePeHttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(PhonePeHttpClientFactory.class);

    public static OkHttpClient buildOkHttpClient(HttpClientConfig httpClientConfig) {
        Preconditions.checkNotNull((Object)httpClientConfig);
        return PhonePeHttpClientFactory.createClient(httpClientConfig);
    }

    private static OkHttpClient createClient(HttpClientConfig httpClientConfig) {
        int connections = httpClientConfig.getConnections();
        connections = connections == 0 ? 10 : connections;
        int idleTimeOutSeconds = httpClientConfig.getIdleTimeOutSeconds();
        idleTimeOutSeconds = idleTimeOutSeconds == 0 ? 30 : idleTimeOutSeconds;
        int connTimeout = httpClientConfig.getConnectTimeoutMs();
        connTimeout = connTimeout == 0 ? 10000 : connTimeout;
        int opTimeout = httpClientConfig.getOpTimeoutMs();
        opTimeout = opTimeout == 0 ? 10000 : opTimeout;
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(connections);
        dispatcher.setMaxRequestsPerHost(connections);
        ConnectionSpec connectionSpec = httpClientConfig.isSecured() ? new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).allEnabledTlsVersions().allEnabledCipherSuites().build() : null;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().followRedirects(false).followSslRedirects(false).retryOnConnectionFailure(true).connectionPool(new ConnectionPool(connections, (long)idleTimeOutSeconds, TimeUnit.SECONDS)).connectTimeout((long)connTimeout, TimeUnit.MILLISECONDS).readTimeout((long)opTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)opTimeout, TimeUnit.MILLISECONDS).dispatcher(dispatcher);
        if (connectionSpec != null) {
            clientBuilder.connectionSpecs(Collections.singletonList(connectionSpec));
        }
        clientBuilder.hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        return clientBuilder.build();
    }
}

