/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.init;

import com.phonepe.sdk.javasdk.transaction.init.TransactionInitComponent;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitDecorator;
import com.phonepe.sdk.javasdk.transaction.init.models.AllowedAccountConstraint;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.models.MerchantConstraints;
import com.phonepe.sdk.javasdk.transaction.init.models.MerchantContext;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountConstraintsTransactionComponent
extends TransactionInitDecorator {
    private static final Logger log = LoggerFactory.getLogger(AccountConstraintsTransactionComponent.class);
    private TransactionInitComponent transactionInitComponent;
    private List<AllowedAccountConstraint> allowedAccountConstraints;

    public AccountConstraintsTransactionComponent(TransactionInitComponent transactionInitComponent, List<AllowedAccountConstraint> allowedAccountConstraints) {
        super(transactionInitComponent);
        this.allowedAccountConstraints = allowedAccountConstraints;
    }

    @Override
    public InitRequest getInitRequest(String merchantId, String transactionId, Long amount) {
        InitRequest initRequest = this.transactionInitComponent.getInitRequest(merchantId, transactionId, amount);
        MerchantContext merchantContext = initRequest.getMerchantContext();
        MerchantConstraints merchantConstraints = MerchantConstraints.builder().account(this.allowedAccountConstraints).build();
        merchantContext.setConstraints(merchantConstraints);
        initRequest.setMerchantContext(merchantContext);
        return initRequest;
    }
}

