/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.http.utils;

import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.models.Endpoint;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static byte[] body(Response response) throws IOException {
        try {
            ResponseBody body = response.body();
            return body.bytes();
        }
        catch (IOException ex) {
            log.error("Exception occurred while performing response to byte conversion");
            return null;
        }
    }

    public static String bodyString(Response response) throws IOException {
        try {
            ResponseBody body = response.body();
            return body.string();
        }
        catch (IOException ex) {
            log.error("Exception occurred while performing response to byte conversion");
            return null;
        }
    }

    public static HttpUrl getSecureHttpUrl(Endpoint endpoint, String url) {
        Preconditions.checkNotNull((Object)endpoint);
        return endpoint.secureUrl(url);
    }

    public static HttpUrl getHttpUrl(Endpoint endpoint, String url) {
        Preconditions.checkNotNull((Object)endpoint);
        return endpoint.url(url);
    }

    public static HttpHeaderPair getHeaderPair(String name, String value) {
        return HttpHeaderPair.builder().name(name).value(value).build();
    }

    public static HttpHeaderPair getContentTypeHeaderPair() {
        return HttpUtils.getHeaderPair("Content-Type", "application/json");
    }

    public static <T1, T2> void checkNotNull(T1 t, T2 t2, String message) {
        if (t == null && t2 == null) {
            throw new RuntimeException(message);
        }
    }
}

