/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.config.models;

public class ThreadPool {
    private boolean semaphoreIsolation;
    private int concurrency;
    private int maxRequestQueueSize;
    private int dynamicRequestQueueSize;
    private int timeout;

    private static boolean $default$semaphoreIsolation() {
        return false;
    }

    private static int $default$concurrency() {
        return 8;
    }

    private static int $default$maxRequestQueueSize() {
        return 128;
    }

    private static int $default$dynamicRequestQueueSize() {
        return 16;
    }

    private static int $default$timeout() {
        return 1000;
    }

    public static ThreadPoolBuilder builder() {
        return new ThreadPoolBuilder();
    }

    public boolean isSemaphoreIsolation() {
        return this.semaphoreIsolation;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public int getMaxRequestQueueSize() {
        return this.maxRequestQueueSize;
    }

    public int getDynamicRequestQueueSize() {
        return this.dynamicRequestQueueSize;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setSemaphoreIsolation(boolean semaphoreIsolation) {
        this.semaphoreIsolation = semaphoreIsolation;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public void setMaxRequestQueueSize(int maxRequestQueueSize) {
        this.maxRequestQueueSize = maxRequestQueueSize;
    }

    public void setDynamicRequestQueueSize(int dynamicRequestQueueSize) {
        this.dynamicRequestQueueSize = dynamicRequestQueueSize;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadPool)) {
            return false;
        }
        ThreadPool other = (ThreadPool)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSemaphoreIsolation() != other.isSemaphoreIsolation()) {
            return false;
        }
        if (this.getConcurrency() != other.getConcurrency()) {
            return false;
        }
        if (this.getMaxRequestQueueSize() != other.getMaxRequestQueueSize()) {
            return false;
        }
        if (this.getDynamicRequestQueueSize() != other.getDynamicRequestQueueSize()) {
            return false;
        }
        return this.getTimeout() == other.getTimeout();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadPool;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSemaphoreIsolation() ? 79 : 97);
        result = result * 59 + this.getConcurrency();
        result = result * 59 + this.getMaxRequestQueueSize();
        result = result * 59 + this.getDynamicRequestQueueSize();
        result = result * 59 + this.getTimeout();
        return result;
    }

    public String toString() {
        return "ThreadPool(semaphoreIsolation=" + this.isSemaphoreIsolation() + ", concurrency=" + this.getConcurrency() + ", maxRequestQueueSize=" + this.getMaxRequestQueueSize() + ", dynamicRequestQueueSize=" + this.getDynamicRequestQueueSize() + ", timeout=" + this.getTimeout() + ")";
    }

    public ThreadPool(boolean semaphoreIsolation, int concurrency, int maxRequestQueueSize, int dynamicRequestQueueSize, int timeout) {
        this.semaphoreIsolation = semaphoreIsolation;
        this.concurrency = concurrency;
        this.maxRequestQueueSize = maxRequestQueueSize;
        this.dynamicRequestQueueSize = dynamicRequestQueueSize;
        this.timeout = timeout;
    }

    public ThreadPool() {
    }

    public static class ThreadPoolBuilder {
        private boolean semaphoreIsolation$set;
        private boolean semaphoreIsolation;
        private boolean concurrency$set;
        private int concurrency;
        private boolean maxRequestQueueSize$set;
        private int maxRequestQueueSize;
        private boolean dynamicRequestQueueSize$set;
        private int dynamicRequestQueueSize;
        private boolean timeout$set;
        private int timeout;

        ThreadPoolBuilder() {
        }

        public ThreadPoolBuilder semaphoreIsolation(boolean semaphoreIsolation) {
            this.semaphoreIsolation = semaphoreIsolation;
            this.semaphoreIsolation$set = true;
            return this;
        }

        public ThreadPoolBuilder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrency$set = true;
            return this;
        }

        public ThreadPoolBuilder maxRequestQueueSize(int maxRequestQueueSize) {
            this.maxRequestQueueSize = maxRequestQueueSize;
            this.maxRequestQueueSize$set = true;
            return this;
        }

        public ThreadPoolBuilder dynamicRequestQueueSize(int dynamicRequestQueueSize) {
            this.dynamicRequestQueueSize = dynamicRequestQueueSize;
            this.dynamicRequestQueueSize$set = true;
            return this;
        }

        public ThreadPoolBuilder timeout(int timeout) {
            this.timeout = timeout;
            this.timeout$set = true;
            return this;
        }

        public ThreadPool build() {
            boolean semaphoreIsolation = this.semaphoreIsolation;
            if (!this.semaphoreIsolation$set) {
                semaphoreIsolation = ThreadPool.$default$semaphoreIsolation();
            }
            int concurrency = this.concurrency;
            if (!this.concurrency$set) {
                concurrency = ThreadPool.$default$concurrency();
            }
            int maxRequestQueueSize = this.maxRequestQueueSize;
            if (!this.maxRequestQueueSize$set) {
                maxRequestQueueSize = ThreadPool.$default$maxRequestQueueSize();
            }
            int dynamicRequestQueueSize = this.dynamicRequestQueueSize;
            if (!this.dynamicRequestQueueSize$set) {
                dynamicRequestQueueSize = ThreadPool.$default$dynamicRequestQueueSize();
            }
            int timeout = this.timeout;
            if (!this.timeout$set) {
                timeout = ThreadPool.$default$timeout();
            }
            return new ThreadPool(semaphoreIsolation, concurrency, maxRequestQueueSize, dynamicRequestQueueSize, timeout);
        }

        public String toString() {
            return "ThreadPool.ThreadPoolBuilder(semaphoreIsolation=" + this.semaphoreIsolation + ", concurrency=" + this.concurrency + ", maxRequestQueueSize=" + this.maxRequestQueueSize + ", dynamicRequestQueueSize=" + this.dynamicRequestQueueSize + ", timeout=" + this.timeout + ")";
        }
    }
}

