package com.phonepe.sdk.javasdk.transaction.init;

import com.phonepe.sdk.javasdk.transaction.init.models.AllowedAccountConstraint;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.models.MerchantConstraints;
import com.phonepe.sdk.javasdk.transaction.init.models.MerchantContext;
import lombok.Builder;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

@Slf4j
public class AccountConstraintsTransactionComponent extends TransactionInitDecorator{

    private List<AllowedAccountConstraint> allowedAccountConstraints;

    @Builder
    public AccountConstraintsTransactionComponent(final TransactionInitComponent transactionInitComponent,
                                                  final List<AllowedAccountConstraint> allowedAccountConstraints) {
        super(transactionInitComponent);
        this.allowedAccountConstraints = allowedAccountConstraints;
    }

    @Override
    public InitRequest getInitRequest(final String merchantId,
                                      final String transactionId,
                                      final Long amount) {
        InitRequest initRequest = this.transactionInitComponent.getInitRequest(merchantId, transactionId, amount);
        MerchantContext merchantContext = initRequest.getMerchantContext();
        MerchantConstraints merchantConstraints = MerchantConstraints.builder()
                                                                     .account(this.allowedAccountConstraints)
                                                                     .build();
        merchantContext.setConstraints(merchantConstraints);
        initRequest.setMerchantContext(merchantContext);
        return initRequest;
    }
}
